(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     43741,        992]*)
(*NotebookOutlinePosition[     44449,       1016]*)
(*  CellTagsIndexPosition[     44405,       1012]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(a1 = 0; a2 = 2; a3 = 2; c1 = 30; c2 = 75; c3 = 25; 
    d = 3;\), "\[IndentingNewLine]", 
    \(\(t = \@\(\((c1 - a1)\)^2\  + \((c2 - a2)\)^2\  + \(\(\((c3 - a3)\)^2\)\
\(\ \)\)\);\)\), "\[IndentingNewLine]", 
    \(\(b1 = a1 + \((t - d)\)*\((c1 - a1)\)/t;\)\), "\[IndentingNewLine]", 
    \(\(b2 = a2 + \((t - d)\)*\((c2 - a2)\)/t;\)\), "\[IndentingNewLine]", 
    \(\(b3 = a3 + \((t - d)\)*\((c3 - a3)\)/t;\)\), "\[IndentingNewLine]", 
    \(\(K[x_, y_, 
          z_] := \((\((c1 - b1)\)*\((c1 - a1)\) + \((c2 - b2)\)*\((c2 - 
                    a2)\) + \((c3 - b3)\)*\((c3 - a3)\))\)/\((\((c1 - 
                    x)\)*\((c1 - a1)\) + \((c2 - y)\)*\((c2 - a2)\) + \((c3 - 
                    z)\)*\((c3 - a3)\))\);\)\), "\[IndentingNewLine]", 
    \(\(q1[x_, y_, z_] := 
        c1 + K[x, y, z]*\((x - c1)\);\)\), "\[IndentingNewLine]", 
    \(\(q2[x_, y_, z_] := 
        c2 + K[x, y, z]*\((y - c2)\);\)\), "\[IndentingNewLine]", 
    \(\(q3[x_, y_, z_] := 
        c3 + K[x, y, z]*\((z - c3)\);\)\), "\[IndentingNewLine]", 
    \(i1 = \((b1 - a1)\)/\((t - d)\); i2 = \((b2 - a2)\)/\((t - d)\); 
    i3 = \((b3 - a3)\)/\((t - d)\);\), "\[IndentingNewLine]", 
    \(tt2 = \((b1 - a1)\)^2\  + \((b2 - a2)\)^2; 
    tt3 = \((b3 - a3)\)^2\  + tt2;\), "\[IndentingNewLine]", 
    \(k1 = \(-\(\(\((b1 - a1)\)*\((b3 - a3)\)\)\/\@\(tt2*tt3\)\)\); 
    k2 = \(-\(\(\((b2 - a2)\)*\((b3 - a3)\)\)\/\@\(tt2*tt3\)\)\); 
    k3 = \@\(tt2\/tt3\);\), "\[IndentingNewLine]", 
    \(j1 = k2*i3 - k3*i2; j2 = k3*i1 - k1*i3; 
    j3 = k1*i2 - k2*i1;\), "\[IndentingNewLine]", 
    \(\(FX[x_, y_, 
          z_] := \((q1[x, y, z] - b1)\)*j1 + \((q2[x, y, z] - b2)\)*
            j2 + \((q3[x, y, z] - b3)\)*j3;\)\), "\[IndentingNewLine]", 
    \(\(FY[x_, y_, 
          z_] := \((q1[x, y, z] - b1)\)*k1 + \((q2[x, y, z] - b2)\)*
            k2 + \((q3[x, y, z] - b3)\)*k3;\)\), "\[IndentingNewLine]", 
    \(xma = 3; yma = 4; zma = 3; yahaba = 1.9;\), "\[IndentingNewLine]", 
    \(xxd = Abs[FX[0, yma, 0] - FX[xma, 0, 0]]; 
    yyd = 
      Abs[FY[0, 0, zma] - 
          Min[FY[xma, 0, 0], FY[0, yma, 0]]];\), "\[IndentingNewLine]", 
    \(ar = yyd/xxd; wx = \((t/d)\)*xxd/50; 
    hx = yahaba*0.2*wx;\), "\[IndentingNewLine]", 
    \(wz = \((t/d)\)*yyd/50; hz = yahaba*wz*0.2; wy = wx; hy = hz; 
    LX = {Thickness[
          0.00402], {Line[{{FX[0, 0, 0], FY[0, 0, 0]}, {FX[xma, 0, 0], 
                FY[xma, 0, 0]}}]}, {Line[{{FX[xma - wx, hx, 0], 
                FY[xma - wx, hx, 0]}, {FX[xma, 0, 0], 
                FY[xma, 0, 0]}, {FX[xma - wx, \(-hx\), 0], 
                FY[xma - wx, \(-hx\), 0]}}]}}; 
    LY = {Thickness[
          0.00402], {Line[{{FX[0, 0, 0], FY[0, 0, 0]}, {FX[0, yma, 0], 
                FY[0, yma, 0]}}]}, {Line[{{FX[0, yma - wy, hy], 
                FY[0, yma - wy, hy]}, {FX[0, yma, 0], 
                FY[0, yma, 0]}, {FX[0, yma - wy, \(-hy\)], 
                FY[0, yma - wy, \(-hy\)]}}]}};\), "\n", 
    \(\(LZ = {Thickness[
            0.00402], {Line[{{FX[0, 0, 0], FY[0, 0, 0]}, {FX[0, 0, zma], 
                  FY[0, 0, zma]}}]}, {Line[{{FX[0, hz, zma - wz], 
                  FY[0, hz, zma - wz]}, {FX[0, 0, zma], 
                  FY[0, 0, zma]}, {FX[0, \(-hz\), zma - wz], 
                  FY[0, \(-hz\), zma - wz]}}]}};\)\)}], "Input"],

Cell[BoxData[{
    \(\(f[x_, y_] := 2.5 - 0.6*x^2 + 0.8*x*y - 0.3*y^2;\)\), "\n", 
    \(x1 = 0.8; x2 = 1.8; y1 = 1.5; y2 = 3;\), "\n", 
    \(\(fG = {Table[
            Line[Table[{FX[x, y, f[x, y]], FY[x, y, f[x, y]]}, {y, y1, y2, 
                  0.1}]], {x, x1, x2, 0.1}], 
          Table[Line[
              Table[{FX[x, y, f[x, y]], FY[x, y, f[x, y]]}, {x, x1, x2, 
                  0.1}]], {y, y1, y2, 0.1}]};\)\), "\n", 
    \(DL1 = {Dashing[{0.01, 
            0.01}], {Line[{{FX[x1, 0, 0], FY[x1, 0, 0]}, {FX[x1, y2, 0], 
                FY[x1, y2, 0]}}], 
          Line[{{FX[0, y1, 0], FY[0, y1, 0]}, {FX[x2, y1, 0], 
                FY[x2, y1, 0]}}], 
          Line[{{FX[x2, 0, 0], FY[x2, 0, 0]}, {FX[x2, y2, 0], 
                FY[x2, y2, 0]}, {FX[0, y2, 0], FY[0, y2, 0]}}]}}; 
    DL2 = {Dashing[{0.01, 0.01}], 
        Table[Line[{{FX[x, y, 0], FY[x, y, 0]}, {FX[x, y, f[x, y]], 
                FY[x, y, f[x, y]]}}], {x, x1, x2, x2 - x1}, {y, y1, y2, 
            y2 - y1}]};\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[{LX, LY, LZ, fG, DL1, DL2}], 
      AspectRatio \[Rule] Automatic, PlotRange -> All]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .92373 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.803441 6.13463 0.576852 6.13463 [
[ 0 0 0 0 ]
[ 1 .92373 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.00402 w
[ ] 0 setdash
.63795 .27153 m
.02381 .19716 L
s
.0439 .19732 m
.02381 .19716 L
.039 .20127 L
s
.63795 .27153 m
.97619 .02292 L
s
.9687 .03489 m
.97619 .02292 L
.96867 .02199 L
s
.63795 .27153 m
.63629 .90174 L
s
.63877 .88348 m
.63629 .90174 L
.63389 .88668 L
s
.5 Mabswid
.59534 .67291 m
.60365 .66097 L
.61198 .64772 L
.62033 .63315 L
.6287 .61725 L
.63708 .60003 L
.64549 .58148 L
.65391 .5616 L
.66236 .54039 L
.67082 .51785 L
.67929 .49397 L
.68778 .46875 L
.69629 .44219 L
.70481 .41429 L
.71335 .38505 L
.7219 .35447 L
s
.57453 .67445 m
.58281 .66423 L
.59112 .6527 L
.59945 .63985 L
.6078 .62567 L
.61617 .61018 L
.62456 .59336 L
.63296 .57521 L
.64139 .55572 L
.64983 .53491 L
.65829 .51276 L
.66677 .48927 L
.67527 .46444 L
.68378 .43827 L
.6923 .41076 L
.70084 .3819 L
s
.5537 .6734 m
.56197 .6649 L
.57025 .65509 L
.57856 .64396 L
.58689 .63152 L
.59524 .61775 L
.6036 .60265 L
.61199 .58623 L
.6204 .56848 L
.62883 .54939 L
.63727 .52897 L
.64573 .50722 L
.65421 .48412 L
.66271 .45968 L
.67122 .4339 L
.67975 .40678 L
s
.53287 .66977 m
.54111 .66299 L
.54937 .6549 L
.55765 .64549 L
.56596 .63477 L
.57429 .62273 L
.58263 .60936 L
.591 .59467 L
.59939 .57865 L
.6078 .5613 L
.61623 .54261 L
.62467 .52259 L
.63314 .50122 L
.64162 .47852 L
.65012 .45448 L
.65863 .42908 L
s
.51203 .66355 m
.52025 .65848 L
.52848 .65211 L
.53674 .64443 L
.54502 .63543 L
.55332 .62511 L
.56165 .61348 L
.57 .60052 L
.57836 .58623 L
.58675 .57061 L
.59516 .55366 L
.60359 .53537 L
.61203 .51574 L
.6205 .49478 L
.62898 .47247 L
.63748 .44882 L
s
.49119 .65473 m
.49938 .65138 L
.50758 .64673 L
.51582 .64077 L
.52407 .63349 L
.53235 .6249 L
.54065 .615 L
.54897 .60377 L
.55732 .59121 L
.56569 .57733 L
.57407 .56211 L
.58248 .54556 L
.59091 .52767 L
.59936 .50844 L
.60782 .48787 L
.61631 .46596 L
s
.47035 .64333 m
.47851 .64169 L
.48668 .63875 L
.49489 .63451 L
.50312 .62896 L
.51137 .62209 L
.51964 .61391 L
.52794 .60441 L
.53626 .59359 L
.54461 .58144 L
.55297 .56796 L
.56136 .55315 L
.56977 .537 L
.57819 .51951 L
.58664 .50068 L
.59511 .48051 L
s
.44951 .62933 m
.45764 .6294 L
.46578 .62817 L
.47396 .62565 L
.48216 .62182 L
.49038 .61668 L
.49863 .61022 L
.5069 .60245 L
.5152 .59336 L
.52352 .58295 L
.53186 .57121 L
.54022 .55813 L
.54861 .54372 L
.55701 .52798 L
.56544 .51089 L
.57389 .49246 L
s
.42868 .61273 m
.43677 .61451 L
.44488 .615 L
.45303 .61419 L
.4612 .61207 L
.46939 .60866 L
.47761 .60393 L
.48585 .59789 L
.49412 .59053 L
.50242 .58185 L
.51073 .57184 L
.51907 .5605 L
.52743 .54784 L
.53582 .53383 L
.54422 .51849 L
.55265 .50181 L
s
.40785 .59354 m
.41591 .59703 L
.42399 .59922 L
.4321 .60012 L
.44024 .59973 L
.4484 .59803 L
.45659 .59502 L
.4648 .59071 L
.47304 .58508 L
.48131 .57813 L
.4896 .56986 L
.49791 .56026 L
.50625 .54933 L
.51461 .53707 L
.52299 .52347 L
.53139 .50854 L
s
.38703 .57176 m
.39505 .57694 L
.4031 .58084 L
.41118 .58345 L
.41928 .58477 L
.42741 .58479 L
.43557 .58351 L
.44375 .58092 L
.45196 .57701 L
.4602 .5718 L
.46846 .56526 L
.47675 .5574 L
.48506 .54821 L
.49339 .53769 L
.50175 .52584 L
.51013 .51265 L
s
.59534 .67291 m
.57453 .67445 L
.5537 .6734 L
.53287 .66977 L
.51203 .66355 L
.49119 .65473 L
.47035 .64333 L
.44951 .62933 L
.42868 .61273 L
.40785 .59354 L
.38703 .57176 L
s
.60365 .66097 m
.58281 .66423 L
.56197 .6649 L
.54111 .66299 L
.52025 .65848 L
.49938 .65138 L
.47851 .64169 L
.45764 .6294 L
.43677 .61451 L
.41591 .59703 L
.39505 .57694 L
s
.61198 .64772 m
.59112 .6527 L
.57025 .65509 L
.54937 .6549 L
.52848 .65211 L
.50758 .64673 L
.48668 .63875 L
.46578 .62817 L
.44488 .615 L
.42399 .59922 L
.4031 .58084 L
s
.62033 .63315 m
.59945 .63985 L
.57856 .64396 L
.55765 .64549 L
.53674 .64443 L
.51582 .64077 L
.49489 .63451 L
.47396 .62565 L
.45303 .61419 L
.4321 .60012 L
.41118 .58345 L
s
.6287 .61725 m
.6078 .62567 L
.58689 .63152 L
.56596 .63477 L
.54502 .63543 L
.52407 .63349 L
.50312 .62896 L
.48216 .62182 L
.4612 .61207 L
.44024 .59973 L
.41928 .58477 L
s
.63708 .60003 m
.61617 .61018 L
.59524 .61775 L
.57429 .62273 L
.55332 .62511 L
.53235 .6249 L
.51137 .62209 L
.49038 .61668 L
.46939 .60866 L
.4484 .59803 L
.42741 .58479 L
s
.64549 .58148 m
.62456 .59336 L
.6036 .60265 L
.58263 .60936 L
.56165 .61348 L
.54065 .615 L
.51964 .61391 L
.49863 .61022 L
.47761 .60393 L
.45659 .59502 L
.43557 .58351 L
s
.65391 .5616 m
.63296 .57521 L
.61199 .58623 L
.591 .59467 L
.57 .60052 L
.54897 .60377 L
.52794 .60441 L
.5069 .60245 L
.48585 .59789 L
.4648 .59071 L
.44375 .58092 L
s
.66236 .54039 m
.64139 .55572 L
.6204 .56848 L
.59939 .57865 L
.57836 .58623 L
.55732 .59121 L
.53626 .59359 L
.5152 .59336 L
.49412 .59053 L
.47304 .58508 L
.45196 .57701 L
s
.67082 .51785 m
.64983 .53491 L
.62883 .54939 L
.6078 .5613 L
.58675 .57061 L
.56569 .57733 L
.54461 .58144 L
.52352 .58295 L
.50242 .58185 L
.48131 .57813 L
.4602 .5718 L
s
.67929 .49397 m
.65829 .51276 L
.63727 .52897 L
.61623 .54261 L
.59516 .55366 L
.57407 .56211 L
.55297 .56796 L
.53186 .57121 L
.51073 .57184 L
.4896 .56986 L
.46846 .56526 L
s
.68778 .46875 m
.66677 .48927 L
.64573 .50722 L
.62467 .52259 L
.60359 .53537 L
.58248 .54556 L
.56136 .55315 L
.54022 .55813 L
.51907 .5605 L
.49791 .56026 L
.47675 .5574 L
s
.69629 .44219 m
.67527 .46444 L
.65421 .48412 L
.63314 .50122 L
.61203 .51574 L
.59091 .52767 L
.56977 .537 L
.54861 .54372 L
.52743 .54784 L
.50625 .54933 L
.48506 .54821 L
s
.70481 .41429 m
.68378 .43827 L
.66271 .45968 L
.64162 .47852 L
.6205 .49478 L
.59936 .50844 L
.57819 .51951 L
.55701 .52798 L
.53582 .53383 L
.51461 .53707 L
.49339 .53769 L
s
.71335 .38505 m
.6923 .41076 L
.67122 .4339 L
.65012 .45448 L
.62898 .47247 L
.60782 .48787 L
.58664 .50068 L
.56544 .51089 L
.54422 .51849 L
.52299 .52347 L
.50175 .52584 L
s
.7219 .35447 m
.70084 .3819 L
.67975 .40678 L
.65863 .42908 L
.63748 .44882 L
.61631 .46596 L
.59511 .48051 L
.57389 .49246 L
.55265 .50181 L
.53139 .50854 L
.51013 .51265 L
s
[ .01 .01 ] 0 setdash
.47574 .25189 m
.72227 .06615 L
s
.76141 .18079 m
.38991 .13496 L
s
.27139 .22714 m
.51233 .03976 L
.88888 .0871 L
s
.59702 .16051 m
.59534 .67291 L
s
.72227 .06615 m
.7219 .35447 L
s
.38991 .13496 m
.38703 .57176 L
s
.51233 .03976 m
.51013 .51265 L
s
0 0 m
1 0 L
1 .92373 L
0 .92373 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 266},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00012R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolF0?ooo`@000001`3oool00?l0oooo5`3oool2000000P0oooo
003o0?oooaH0oooo0P0000090?ooo`00o`3ooolE0?ooo`030000003oool0000000T0oooo003o0?oo
oa<0oooo0P0000000`3oool000000?ooo`090?ooo`00T`3oool200000080oooo0P00001h0?ooo`03
0000003oool0oooo00`0oooo002A0?ooo`<000001@3oool2000000030?ooo`00000000000780oooo
00<000000?ooo`3oool03@3oool00980oooo00<000000?ooo`3oool02@3oool200000080oooo1000
001X0?ooo`800000403oool008l0oooo00@000000?ooo`3oool000005@3oool4000000030?ooo`00
0000000005h0oooo00<000000?ooo`3oool0403oool008d0oooo0P00000P0?ooo`8000000P3oool4
000005D0oooo00<000000?ooo`3oool04@3oool00;T0oooo100000020?ooo`030000003oool0oooo
04P0oooo0P00000D0?ooo`00R`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02/0
oooo0P0000020?ooo`800000@`3oool00`000000oooo0?ooo`0D0?ooo`00R@3oool2000000L0oooo
00<000000?ooo`3oool0<@3oool200000080oooo100000000`3oool000000?ooo`0f0?ooo`800000
5`3oool008P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0i0?ooo`D000000P3o
ool2000002l0oooo00<000000?ooo`3oool05`3oool00980oooo00<000000?ooo`3oool0>03oool0
0`000000oooo000000070?ooo`8000000P3oool4000002H0oooo00<000000?ooo`3oool0603oool0
08H0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`0?0?ooo`@0000000<0oooo0000
000000006`3oool2000001/0oooo00240?ooo`800000303oool00`000000oooo0?ooo`0e0?ooo`03
0000003oool0oooo01/0oooo0P0000020?ooo`800000503oool00`000000oooo0?ooo`0K0?ooo`00
TP3oool00`000000oooo0?ooo`0c0?ooo`800000903oool200000080oooo1000000;0?ooo`030000
003oool0oooo01`0oooo00210?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`0U0?ooo`@000000P3oool4000001l0oooo00200?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo02`0oooo00<000000?ooo`3oool07`3oool007l0oooo00<000000?ooo`3oool0@`3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo02X0oooo0P00000R0?ooo`00a03oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool08P3oool007d0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`1U0?ooo`030000003oool0oooo02<0oooo
001k0?ooo`8000005@3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo03@0oooo0P00
000V0?ooo`00TP3oool00`000000oooo0?ooo`0Z0?ooo`8000003P3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo02H0oooo001h0?ooo`030000003oool0oooo01L0oooo00<000000?oo
o`3oool0>P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo02L0oooo001g0?ooo`03
0000003oool0oooo04<0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0R0?ooo`80
0000:P3oool007H0oooo00<000000?ooo`3oool0@P3oool200000180oooo00<000000?ooo`3oool0
8@3oool00`000000oooo0?ooo`0Z0?ooo`00TP3oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo03D0oooo00<000000?ooo`3oool0:`3oool007@0oooo00<000000?ooo`3oool06`3oool0
0`000000oooo0?ooo`1K0?ooo`800000;P3oool007<0oooo00<000000?ooo`3oool0703oool00`00
0000oooo0?ooo`0S0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool07@3oool00`00
0000oooo0?ooo`0^0?ooo`00LP3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0240
oooo0P00000G0?ooo`030000003oool0oooo01/0oooo0P00000a0?ooo`00K`3oool00`000000oooo
0000001M0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0<@3oool006h0oooo0P00
00020?ooo`8000000P3oool4000003X0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0I0?ooo`030000003oool0oooo0380oooo001]0?ooo`030000003oool0000000`0oooo1000000B
0?ooo`030000003oool0oooo01d0oooo0P00000e0?ooo`800000=@3oool006l0oooo00<000000?oo
o`3oool0403oool4000000030?ooo`000000000000T0oooo00<000000?ooo`3oool0703oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0=@3oool006/0
oooo00<000000?ooo`3oool06`3oool200000080oooo100000000`3oool000000?ooo`0K0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0f0?ooo`00
JP3oool00`000000oooo0?ooo`0V0?ooo`@0000000<0oooo000000000000503oool00`000000oooo
0?ooo`0N0?ooo`030000003oool0oooo01<0oooo0P00000i0?ooo`00J@3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo02P0oooo0P0000020?ooo`@000002`3oool00`000000oooo0?oo
o`0O0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0>@3oool006H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00l0oooo10000002
0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0>P3oool006D0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo01D0oooo0`0000020?oo
o`@00000;P3oool2000003d0oooo001T0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`0D0?ooo`030000003oool0000000T0oooo1000000F0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool0?@3oool00980oooo00<000000?ooo`3oool0
4`3oool010000000oooo0?ooo`00000?0?ooo`<000000P3oool2000000d0oooo00<000000?ooo`3o
ool0303oool200000400oooo001R0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool0
6@3oool200000080oooo100000050?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
@03oool00600oooo0P00000=0?ooo`030000003oool0oooo0380oooo0P00000V0?ooo`@0000000<0
oooo0000000000002@3oool00`000000oooo0?ooo`110?ooo`00G`3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo02D0oooo0P0000020?ooo`D00000A03oool005d0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool0:`3oool00`000000oooo0?ooo`140?ooo`00G03oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0200oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo0240oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`150?ooo`00
F`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00@0oooo0P0000180?ooo`00K`3o
ool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`180?ooo`001P3oool7000004`0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`0[0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`190?ooo`002@3oool:000004@0oooo0P00000F0?ooo`030000003oool0oooo
0200oooo00<000000?ooo`3oool01P3oool2000000h0oooo00<000000?ooo`3oool0903oool20000
04`0oooo000C0?ooo`T00000>P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02<0
oooo00<000000?ooo`3oool0C03oool001`0oooo2000000`0?ooo`030000003oool0oooo03/0oooo
00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0Q0?ooo`800000C`3oool002@0oooo2000
000W0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0200oooo0P00001@0?ooo`00;03oool9000001d0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0T0?ooo`800000=@3oool00`000000oooo0000001@
0?ooo`00=@3oool800000380oooo00<000000?ooo`3oool0F@3oool200000080oooo00<000000?oo
o`3oool0CP3oool003d0oooo2@00000:0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3o
ool0803oool2000001L0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`1C0?ooo`00
AP3oool:000001l0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo01/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1>0?ooo`00C@3o
ool:000003X0oooo0P00000H0?ooo`030000003oool0oooo01T0oooo0P0000060?ooo`030000003o
ool0oooo04h0oooo001G0?ooo`P00000C03oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0CP3oool005l0oooo200000080?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool0<P3oool2000000T0oooo00<000000?ooo`3oool0CP3oool006L0
oooo2@00000M0?ooo`8000000`3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo05X0
oooo001_0?ooo`T000006P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01@0oooo
00<000000?ooo`3oool0F`3oool006l0oooo00<000000?ooo`3oool01P3oool9000000T0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0180oooo0P00
000=0?ooo`030000003oool0oooo04h0oooo00210?ooo`T00000203oool00`000000oooo0?ooo`0F
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`1>
0?ooo`00R03oool:000002`0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`1>0?oo
o`00K`3oool00`000000oooo0?ooo`0P0?ooo`P000008P3oool200000140oooo00<000000?ooo`3o
ool0CP3oool006l0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`050?ooo`P00000
2@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0680oooo001_0?ooo`030000003o
ool0oooo0200oooo00<000000?ooo`3oool03@3oool:000000h0oooo00<000000?ooo`3oool0H`3o
ool006l0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0F0?ooo`P000001@3oool2
000001D0oooo00<000000?ooo`3oool0CP3oool00980oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`050?ooo`D000005`3oool00`000000oooo0?ooo`1>0?ooo`00K`3oool00`000000
oooo0?ooo`150?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0CP3oool006l0oooo
00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo04h0oooo
001_0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo06H0oooo001_0?ooo`030000003oool0oooo0200oooo00<00000
0?ooo`3oool05P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo06H0oooo002B0?oo
o`030000003oool0oooo01H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?oo
o`030000003oool0oooo04h0oooo002B0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo04h0oooo001_0?ooo`030000
003oool0oooo04D0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`1>0?ooo`00K`3o
ool00`000000oooo0?ooo`150?ooo`030000003oool0oooo06H0oooo001_0?ooo`030000003oool0
oooo0200oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo06H0oooo001_0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0CP3oool00980
oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool0CP3oool00:/0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo04h0oooo001_0?ooo`030000003oool0oooo04D0oooo00<0
00000?ooo`3oool05@3oool00`000000oooo0?ooo`1>0?ooo`00K`3oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1V
0?ooo`00K`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`1V0?ooo`00K`3oool00`000000oooo0?ooo`0P0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?ooo`03
0000003oool0oooo04h0oooo002B0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo04h0oooo002g0?ooo`030000003o
ool0oooo01D0oooo00<000000?ooo`3oool0CP3oool006l0oooo00<000000?ooo`3oool0A@3oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo04h0oooo001_0?ooo`030000003oool0oooo
0200oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
06H0oooo001_0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool05P3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo06H0oooo002B0?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo04h0oooo
002B0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo04h0oooo001_0?ooo`030000003oool0oooo04D0oooo00<00000
0?ooo`3oool05@3oool00`000000oooo0?ooo`1>0?ooo`00K`3oool00`000000oooo0?ooo`150?oo
o`030000003oool0oooo01@0oooo0P00001@0?ooo`00K`3oool00`000000oooo0?ooo`0P0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0C0?ooo`80
0000D@3oool006l0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool04`3oool200000540oooo002B0?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool000000540oooo002B0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool000000580oooo001_0?ooo`030000003oool0oooo
04D0oooo00<000000?ooo`3oool0403oool010000000oooo0?ooo`00001B0?ooo`00K`3oool00`00
0000oooo0?ooo`0P0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0403oool01000
0000oooo0?ooo`00001B0?ooo`00K`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo
01H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0?0?ooo`040000003oool0oooo
000005<0oooo001_0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00h0oooo0P0000020?ooo`030000003oool0oooo
0540oooo002B0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0=0?ooo`8000000P3oool2000005<0oooo002[0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0303oool010000000oooo0000003oool2000005@0oooo001_0?ooo`030000
003oool0oooo04D0oooo00<000000?ooo`3oool0303oool2000000040?ooo`000000oooo000005@0
oooo001_0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool05P3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00/0oooo00L000000?ooo`000000oooo0000003oool00000
05@0oooo001_0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool05P3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00P0000020?ooo`03
0000003oool0oooo0580oooo001_0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
0P0000020?ooo`030000003oool0oooo05<0oooo002B0?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`8000000P3oool01@000000oooo0?oo
o`3oool0000005D0oooo002g0?ooo`030000003oool0oooo00L0oooo0P0000020?ooo`8000000`3o
ool00`000000oooo0?ooo`1C0?ooo`00K`3oool00`000000oooo0?ooo`150?ooo`030000003oool0
oooo00H0oooo00@000000?ooo`000000oooo0P0000030?ooo`800000E@3oool006l0oooo00<00000
0?ooo`3oool0803oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool01P3oool2000000040?ooo`000000oooo00000080oooo0P00001F0?ooo`00K`3oool0
0`000000oooo0?ooo`0P0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`050?ooo`0;0000003oool000000?ooo`000000oooo0000003oool000000?oo
o`000000EP3oool00980oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool00P0000020?ooo`040000003oool000000000
05L0oooo002B0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo008000000P3oool01@000000oooo0000003oool00000
05L0oooo001_0?ooo`030000003oool0oooo04D0oooo00@000000?ooo`3oool0oooo0`0000020?oo
o`040000003oool0oooo0?ooo`8000000P3oool00`000000oooo0?ooo`1E0?ooo`00K`3oool00`00
0000oooo0?ooo`150?ooo`060000003oool0oooo0000003oool000000P3oool2000000<0oooo00@0
00000?ooo`3oool00000F03oool006l0oooo00<000000?ooo`3oool0803oool00`000000oooo0?oo
o`0F0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`0000000P3oool010000000oooo0000
000000030?ooo`8000000P3oool00`000000oooo0?ooo`1F0?ooo`00K`3oool00`000000oooo0?oo
o`0P0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool02@3oool200000080oooo00D0
00000?ooo`000000oooo000000020?ooo`8000000P3oool2000005P0oooo002B0?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool0203oool2000000<0oooo0P0000020?ooo`060000003o
ool000000?ooo`000000oooo0P00001I0?ooo`00TP3oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo00L0oooo0`0000020?ooo`8000000`3oool2000000060?ooo`000000oooo0000003o
ool00000F@3oool006l0oooo00<000000?ooo`3oool0@P3oool2000000050?ooo`000000oooo0?oo
o`0000000`3oool200000080oooo00D000000?ooo`000000oooo0000001I0?ooo`00K`3oool00`00
0000oooo0?ooo`0P0?ooo`030000003oool0oooo01d0oooo0P0000001@3oool000000?ooo`000000
oooo008000000`3oool010000000oooo0?ooo`3oool200000080oooo00<000000?ooo`3oool0E`3o
ool006l0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo00<0oooo00H000000?ooo`3oool0oooo0000003oool3000000<0oooo0P0000020?ooo`800000
0P3oool00`000000oooo0?ooo`1H0?ooo`00K`3oool00`000000oooo0?ooo`0P0?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`<0000000@0
oooo0000003oool0oooo0P0000030?ooo`050000003oool0oooo0?ooo`000000FP3oool00980oooo
00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`03000000<0oooo0P000000203oool00000
0?ooo`000000oooo0000003oool000000P3oool2000000<0oooo00<000000?ooo`3oool0F03oool0
0:d0oooo00<000000?ooo`000000103oool01@000000oooo0?ooo`000000oooo0080000000@0oooo
0000003oool0oooo0P0000030?ooo`800000FP3oool006l0oooo00<000000?ooo`3oool0>@3oool2
00000080oooo00<000000?ooo`3oool00`0000020?ooo`<000000P3oool3000000040?ooo`000000
oooo0?ooo`800000F`3oool006l0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0E
0?ooo`8000000`3oool01@000000oooo0000003oool0000000<0oooo0P0000020?ooo`8000000`3o
ool01@000000oooo0000003oool0000005/0oooo001_0?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool04`3oool400000080oooo0`0000020?ooo`030000003oool0oooo008000000`3o
ool00`000000oooo0?ooo`020?ooo`80000000<0oooo0000003oool0F`3oool006l0oooo00<00000
0?ooo`3oool0803oool00`000000oooo0?ooo`0B0?ooo`040000003oool00000000000<0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0000003oool000000080oooo0P0000030?ooo`800000
0P3oool00`000000oooo0?ooo`1J0?ooo`00TP3oool00`000000oooo0?ooo`0@0?ooo`8000000P3o
ool2000000040?ooo`0000000000000000<0oooo0`000000103oool000000000003oool2000000@0
oooo00@000000?ooo`3oool00000G@3oool00:<0oooo0P0000040?ooo`050000003oool000000?oo
o`000000103oool010000000oooo0?ooo`3oool3000000030?ooo`000000oooo0080oooo0P000002
0?ooo`030000003oool0oooo05/0oooo001_0?ooo`030000003oool0oooo02h0oooo0`0000000`3o
ool000000?ooo`020?ooo`<000000P3oool00`000000oooo0?ooo`02000000<0oooo0`0000020?oo
o`030000003oool0oooo008000000P3oool2000005d0oooo001_0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool0203oool3000000<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo000000020?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo000000020?oo
o`<0000000<0oooo0000003oool00P00001N0?ooo`00K`3oool00`000000oooo0?ooo`0P0?ooo`03
0000003oool0oooo00D0oooo0`0000000`3oool000000?ooo`030?ooo`030000003oool0oooo0080
00000P3oool00`000000oooo00000002000000040?ooo`000000oooo0?ooo`<0000000<0oooo0000
003oool00P0000020?ooo`050000003oool000000?ooo`000000GP3oool00980oooo00<000000?oo
o`3oool00P3oool3000000<0oooo00<000000?ooo`3oool00P3oool01P000000oooo000000000000
oooo00000080oooo00<000000?ooo`0000000`3oool01@000000oooo0000003oool000000080oooo
00<000000?ooo`0000000`3oool200000080oooo00<000000?ooo`3oool0G03oool00980oooo00<0
00000?ooo`0000000P0000000`3oool000000?ooo`030?ooo`040000003oool0oooo0?ooo`<00000
0P3oool010000000oooo0?ooo`3oool2000000<0oooo0`0000020?ooo`030000003oool0oooo0080
00000`3oool2000000<0oooo00<000000?ooo`3oool0G03oool006l0oooo00<000000?ooo`3oool0
803oool2000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo00000003000000@0oooo
00H000000?ooo`00000000000?ooo`0000030?ooo`030000003oool0oooo0080oooo00<000000?oo
o`0000000P0000030?ooo`050000003oool0oooo0?ooo`000000G`3oool006l0oooo00<000000?oo
o`3oool07`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo0?ooo`<000000`3oool0
10000000oooo0?ooo`3oool300000080oooo00<000000?ooo`3oool00`0000030?ooo`<0000000@0
oooo0000003oool0oooo0`0000030?ooo`030000003oool0oooo05d0oooo001_0?ooo`030000003o
ool0oooo01l0oooo00<000000?ooo`3oool00P3oool00`000000oooo00000003000000@0oooo00@0
00000?ooo`3oool0oooo0P0000040?ooo`050000003oool000000?ooo`000000103oool02@000000
oooo0?ooo`3oool000000?ooo`000000oooo000000030?ooo`800000G`3oool006l0oooo00<00000
0?ooo`3oool07P3oool8000000<0oooo00<000000?ooo`3oool00P3oool4000000030?ooo`000000
oooo0080oooo0`0000020?ooo`030000003oool0oooo008000000`3oool300000080oooo00<00000
0?ooo`3oool00P00001P0?ooo`00S`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool0oooo0`0000030?ooo`030000003oool0oooo0080oooo0P000003
0?ooo`050000003oool000000?ooo`0000000`3oool2000000<0oooo0`0000000`3oool000000?oo
o`1O0?ooo`00SP3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo1@000005
0?ooo`030000003oool0oooo00@000000P3oool3000000040?ooo`000000oooo0?ooo`@000000P3o
ool2000000<0oooo00<000000?ooo`3oool0GP3oool006l0oooo00<000000?ooo`3oool0703oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00@000000`3oool00`000000oooo0?ooo`02
0?ooo`060000003oool000000000003oool00000103oool02`000000oooo0?ooo`3oool000000?oo
o`000000oooo0000003oool000000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`1N0?ooo`00K`3oool00`000000oooo0?ooo`0K0?ooo`X0000000<0oooo0000003oool00`3oool0
10000000oooo0?ooo`3oool4000000<0oooo00<000000?ooo`3oool00P0000030?ooo`<000000P3o
ool00`000000oooo00000003000000<0oooo00<000000?ooo`3oool0G`3oool006l0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00@00000
0?ooo`3oool0oooo1@0000000`3oool000000?ooo`030?ooo`060000003oool000000000003oool0
00000`3oool00`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`000000103oool00`00
0000oooo0?ooo`1O0?ooo`00K`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo00000002000000030?ooo`000000oooo00<0
oooo00@000000?ooo`3oool0oooo0`0000000`3oool00000000000020?ooo`<000000`3oool40000
00040?ooo`000000oooo0?ooo`800000HP3oool008/0oooo3P0000030?ooo`030000003oool0oooo
0080oooo00<000000?ooo`0000000`0000030?ooo`@0000000<0oooo0000003oool00`3oool02P00
0000oooo0?ooo`000000oooo0000003oool000000?ooo`00001R0?ooo`00R@3oool2000000D0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo0?ooo`<0
00000`3oool010000000oooo0?ooo`3oool2000000<0oooo00<000000?ooo`3oool00`0000020?oo
o`@0000000<0oooo0000003oool0HP3oool006l0oooo00<000000?ooo`3oool05P3oool3000000@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000<0
0000103oool00`000000oooo0?ooo`03000000@0oooo00D000000?ooo`000000oooo000000030?oo
o`8000000`3oool00`000000oooo0?ooo`1Q0?ooo`00K`3oool00`000000oooo0?ooo`0E0?ooo`04
0000003oool0oooo0?oooa8000000P3oool00`000000oooo0?ooo`030?ooo`<0000000<0oooo0000
000000000`3oool300000080oooo00<000000?ooo`3oool00P0000030?ooo`030000003oool0oooo
0680oooo001_0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`04000000<0oooo0P0000020?ooo`800000103oool01@000000oooo0000003oool00000
00<0oooo00<000000?ooo`3oool0HP3oool006l0oooo00<000000?ooo`3oool0503oool3000000@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0
000000<0oooo0000003oool00`3oool00`000000oooo00000002000000030?ooo`000000oooo0080
oooo0`000000103oool000000000003oool3000006@0oooo00250?ooo`040000003oool0oooo0?oo
o`H000000`3oool010000000oooo0?ooo`3oool6000000030?ooo`000000oooo00@0oooo00@00000
0?ooo`3oool0oooo100000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0oooo
0`0000000`3oool000000?ooo`1T0?ooo`00K`3oool00`000000oooo0?ooo`0A0?ooo`@00000103o
ool010000000oooo0?ooo`3oool7000000030?ooo`000000oooo00@0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo00000003000000D0oooo00<000000?ooo`3oool00P0000030?ooo`<00000
0P3oool00`000000oooo0?ooo`1S0?ooo`00L03oool2000000l0oooo0P0000040?ooo`H00000103o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0oooo
100000030?ooo`030000003oool0oooo0080oooo00H000000?ooo`00000000000?ooo`0000030?oo
o`050000003oool000000?ooo`000000IP3oool00740oooo1000000:0?ooo`8000000P3oool30000
0080oooo0P0000030?ooo`H000000`3oool010000000oooo0?ooo`3oool6000000030?ooo`000000
oooo00<0oooo00@000000?ooo`3oool0oooo100000020?ooo`030000003oool0oooo00<0000000@0
oooo0000003oool00000IP3oool00780oooo3@0000000`3oool00000000000040?ooo`<000001P3o
ool010000000oooo0?ooo`3oool7000000030?ooo`000000oooo00<0oooo00<000000?ooo`3oool0
0`3oool6000000@0oooo0`000000103oool000000?ooo`3oool2000006L0oooo001c0?ooo`<00000
00D0oooo0000003oool000000?ooo`02000000030?ooo`00000000000080oooo0P0000020?ooo`03
0000003oool0oooo00<000000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`04000000<0oooo00@000000?ooo`3o
ool0oooo0`0000030?ooo`050000003oool000000?ooo`000000I`3oool007@0oooo1@0000001@3o
ool000000?ooo`3oool000000080oooo0P0000020?ooo`<000001@3oool4000000@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`06000000030?ooo`000000oooo00@0oooo1@000004
0?ooo`D00000J03oool007D0oooo0P0000000`3oool0000000000003000000030?ooo`0000000000
0080oooo0`0000020?ooo`<000000P3oool010000000oooo0?ooo`3oool=000000030?ooo`000000
oooo00@0oooo00@000000?ooo`3oool0oooo0`0000030?ooo`040000003oool0oooo0?ooo`800000
0P3oool2000006P0oooo001f0?ooo`H0000000@0oooo0000003oool0oooo0P0000020?ooo`800000
103oool4000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`0000000`0000040?ooo`030000003oool0000000<00000
0`3oool00`000000oooo0?ooo`1W0?ooo`00M`3oool2000000030?ooo`000000000000@0000000<0
oooo0000000000000`3oool200000080oooo00@000000?ooo`3oool0oooo1P0000040?ooo`030000
003oool0oooo0080oooo00@000000?ooo`3oool0oooo100000030?ooo`040000003oool000000?oo
o`<000000`3oool01@000000oooo0?ooo`3oool0000006T0oooo001h0?ooo`80000000<0oooo0000
003oool0100000020?ooo`8000000`3oool3000000D0oooo00@000000?ooo`3oool0oooo3@000000
0`3oool000000?ooo`030?ooo`030000003oool0000000<00000103oool00`000000oooo0?ooo`03
000006T0oooo001j0?ooo`@0000000<0oooo0000003oool00P0000020?ooo`<000000`3oool30000
0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool010000000103oool000000?ooo`0000040?ooo`<0000000<0oooo
000000000000J@3oool007/0oooo0P0000000`3oool000000?ooo`02000000040?ooo`0000000000
00000080oooo0`0000030?ooo`@00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00H0000000<0oooo0000003oool00P3oool2000000<0oooo0`0000030?ooo`800000J@3oool0
07`0oooo200000000`3oool00000000000040?ooo`<00000103oool=000000030?ooo`000000oooo
00<0oooo00<000000?ooo`3oool00`3oool5000000@0oooo00<000000?ooo`000000J@3oool007d0
oooo1@0000000`3oool00000000000020?ooo`8000000P3oool00`000000oooo0?ooo`0300000080
oooo0P0000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`04000000<0oooo00@000000?ooo`3oool0oooo0P0000000`3oool000000?ooo`1X0?oo
o`00OP3oool3000000040?ooo`000000oooo0?ooo`8000000P3oool3000000D0oooo100000040?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P0000000`3oool00000000000030?oo
o`030000003oool0000000<000000P3oool00`000000oooo0?ooo`1W0?ooo`00P03oool500000080
oooo0`0000020?ooo`<000000P3oool010000000oooo0?ooo`3oool=000000030?ooo`000000oooo
00@0oooo0P0000020?ooo`<000000`3oool010000000oooo0?ooo`00001Y0?ooo`00P@3oool60000
0080oooo0P0000040?ooo`@00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo00000003000000@0oooo00D000000?oo
o`3oool0oooo0000001Y0?ooo`00PP3oool00`000000oooo00000003000000<0oooo0P0000020?oo
o`040000003oool0oooo0?ooo`H00000103oool00`000000oooo0?ooo`020?ooo`040000003oool0
oooo0?ooo`@000000`3oool010000000oooo0?ooo`3oool2000000<0oooo00<000000?ooo`3oool0
I`3oool008<0oooo0P0000000`3oool000000?ooo`02000000<0oooo100000040?ooo`040000003o
ool0oooo0?ooo`d0000000<0oooo0000003oool00`3oool00`000000oooo00000003000000@0oooo
00<000000?ooo`3oool0I`3oool008D0oooo00D000000?ooo`00000000000?ooo`03000000@0oooo
1P0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0400000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1W0?ooo`00QP3o
ool500000080oooo0`0000020?ooo`8000000`3oool6000000@0oooo00<000000?ooo`3oool02000
00040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0I`3oool008L0oooo0P000002
0?ooo`<000000P3oool3000000H0oooo00@000000?ooo`3oool0oooo1`0000000`3oool000000?oo
o`030?ooo`040000003oool0oooo0?ooo`8000001P3oool00`000000oooo0?ooo`1W0?ooo`00R@3o
ool2000000<0oooo0`0000020?ooo`<000000P3oool00`000000oooo0?ooo`030?ooo`800000103o
ool00`000000oooo0?ooo`030?ooo`D000001`3oool00`000000oooo0?ooo`1W0?ooo`00R`3oool3
000000<0oooo0`0000020?oooaD000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo06L0oooo002=0?ooo`8000001@3oool3000000D0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`1W0?ooo`00S`3oool200000080oooo0P0000020?ooo`<000000P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`0000080?ooo`03
0000003oool0oooo06L0oooo002A0?ooo`<000001P3ooolA000000030?ooo`000000oooo00P0oooo
00<000000?ooo`3oool0I`3oool009@0oooo0`0000020?ooo`8000001@3oool00`000000oooo0?oo
o`030?ooo`040000003oool0oooo0?ooo`8000002P3oool00`000000oooo0?ooo`1W0?ooo`00U`3o
ool4000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`8000002P3o
ool00`000000oooo0?ooo`1W0?ooo`00V`3oool@000000/0oooo00<000000?ooo`3oool0I`3oool0
0;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo
00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<00000
0?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3o
ool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3o
ool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0
oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<0
00000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?oo
o`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0
I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool0
0;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo
00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<00000
0?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3o
ool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3o
ool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0
oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<0
00000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?oo
o`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0
I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool0
0;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo
00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<00000
0?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3o
ool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3o
ool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0
oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<0
00000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?oo
o`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo00<000000?ooo`3oool0
I`3oool00;H0oooo00<000000?ooo`3oool0I`3oool00;H0oooo0P00001X0?ooo`00]@3oool30000
06P0oooo002e0?ooo`<00000J03oool00;D0oooo0P00001Y0?ooo`00]P3oool00`000000oooo0?oo
o`1W0?ooo`00]P3oool00`000000oooo0?ooo`1W0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {265, 0}} -> {-0.131003, -0.0940328, \
0.000568218, 0.000568218}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
WindowSize->{834, 924},
WindowMargins->{{84, Automatic}, {Automatic, -14}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 3308, 59, 622, "Input"],
Cell[5065, 112, 1013, 19, 210, "Input"],

Cell[CellGroupData[{
Cell[6103, 135, 131, 2, 30, "Input"],
Cell[6237, 139, 37355, 845, 274, 6756, 463, "GraphicsData", "PostScript", \
"Graphics"],
Cell[43595, 986, 130, 3, 29, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

