(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     37565,        907]*)
(*NotebookOutlinePosition[     38270,        931]*)
(*  CellTagsIndexPosition[     38226,        927]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(c1 = 6; c2 = 5; c3 = 7; d = 1;\), "\n", 
    \(\(FX[x_, y_, z_] := c2 + d*\((y - c2)\)/\((c1 - x)\)\ ;\)\), "\n", 
    \(\(FY[x_, y_, z_] := c3 + d*\((z - c3)\)/\((c1 - x)\)\ ;\)\), "\n", 
    \(xma = 3; yma = 4; zma = 3; tt = Abs[c1]\ ; dd = d;\), "\n", 
    \(xxd = Abs[FX[0, yma, 0] - FX[xma, 0, 0]]; 
    yyd = Abs[
        FY[0, 0, zma] - 
          Min[FY[xma, 0, 0], FY[0, yma, 0]]];\), "\[IndentingNewLine]", 
    \(ar = yyd/xxd; wx = \((tt/dd)\)*xxd/50; 
    hx = 0.2*wx;\), "\[IndentingNewLine]", 
    \(wz = \((tt/dd)\)*yyd/50; hz = wz*0.2; wy = wx; hy = hz; 
    LX = {Thickness[
          0.00402], {Line[{{FX[0, 0, 0], FY[0, 0, 0]}, {FX[xma, 0, 0], 
                FY[xma, 0, 0]}}]}, {Line[{{FX[xma - wx, hx, 0], 
                FY[xma - wx, hx, 0]}, {FX[xma, 0, 0], 
                FY[xma, 0, 0]}, {FX[xma - wx, \(-hx\), 0], 
                FY[xma - wx, \(-hx\), 0]}}]}}; 
    LY = {Thickness[
          0.00402], {Line[{{FX[0, 0, 0], FY[0, 0, 0]}, {FX[0, yma, 0], 
                FY[0, yma, 0]}}]}, {Line[{{FX[0, yma - wy, hy], 
                FY[0, yma - wy, hy]}, {FX[0, yma, 0], 
                FY[0, yma, 0]}, {FX[0, yma - wy, \(-hy\)], 
                FY[0, yma - wy, \(-hy\)]}}]}};\), "\n", 
    \(\(LZ = {Thickness[
            0.00402], {Line[{{FX[0, 0, 0], FY[0, 0, 0]}, {FX[0, 0, zma], 
                  FY[0, 0, zma]}}]}, {Line[{{FX[0, hz, zma - wz], 
                  FY[0, hz, zma - wz]}, {FX[0, 0, zma], 
                  FY[0, 0, zma]}, {FX[0, \(-hz\), zma - wz], 
                  FY[0, \(-hz\), zma - wz]}}]}};\)\)}], "Input"],

Cell[BoxData[{
    \(\(f[x_, y_] := 2.5 - 0.6*x^2 + 0.8*x*y - 0.3*y^2;\)\), "\n", 
    \(x1 = 0.8; x2 = 1.8; y1 = 1.5; y2 = 3;\), "\n", 
    \(\(fG = {Table[
            Line[Table[{FX[x, y, f[x, y]], FY[x, y, f[x, y]]}, {y, y1, y2, 
                  0.1}]], {x, x1, x2, 0.1}], 
          Table[Line[
              Table[{FX[x, y, f[x, y]], FY[x, y, f[x, y]]}, {x, x1, x2, 
                  0.1}]], {y, y1, y2, 0.1}]};\)\), "\n", 
    \(DL1 = {Dashing[{0.01, 
            0.01}], {Line[{{FX[x1, 0, 0], FY[x1, 0, 0]}, {FX[x1, y2, 0], 
                FY[x1, y2, 0]}}], 
          Line[{{FX[0, y1, 0], FY[0, y1, 0]}, {FX[x2, y1, 0], 
                FY[x2, y1, 0]}}], 
          Line[{{FX[x2, 0, 0], FY[x2, 0, 0]}, {FX[x2, y2, 0], 
                FY[x2, y2, 0]}, {FX[0, y2, 0], FY[0, y2, 0]}}]}}; 
    DL2 = {Dashing[{0.01, 0.01}], 
        Table[Line[{{FX[x, y, 0], FY[x, y, 0]}, {FX[x, y, f[x, y]], 
                FY[x, y, f[x, y]]}}], {x, x1, x2, x2 - x1}, {y, y1, y2, 
            y2 - y1}]};\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[{LX, LY, LZ, fG, DL1, DL2}], 
      AspectRatio \[Rule] Automatic, PlotRange -> All]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.11111 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.09259 0.634921 -2.93651 0.634921 [
[ 0 0 0 0 ]
[ 1 1.11111 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.00402 w
[ ] 0 setdash
.55291 .7672 m
.02381 .02646 L
s
.0909 .11031 m
.02381 .02646 L
.07652 .11031 L
s
.55291 .7672 m
.97619 .7672 L
s
.95714 .77143 m
.97619 .7672 L
.95714 .76296 L
s
.55291 .7672 m
.55291 1.08466 L
s
.55714 1.06349 m
.55291 1.08466 L
.54868 1.06349 L
s
.5 Mabswid
.65466 .9464 m
.66687 .94286 L
.67908 .93858 L
.69129 .93358 L
.7035 .92784 L
.71571 .92137 L
.72792 .91416 L
.74013 .90623 L
.75234 .89756 L
.76455 .88816 L
.77676 .87802 L
.78897 .86716 L
.80118 .85556 L
.81339 .84322 L
.8256 .83016 L
.83781 .81636 L
s
.64628 .93763 m
.65873 .93501 L
.67118 .93165 L
.68363 .92754 L
.69608 .92269 L
.70853 .91709 L
.72098 .91074 L
.73343 .90364 L
.74588 .8958 L
.75833 .88721 L
.77077 .87787 L
.78322 .86779 L
.79567 .85696 L
.80812 .84538 L
.82057 .83305 L
.83302 .81998 L
s
.63757 .92698 m
.65026 .92533 L
.66296 .92292 L
.67566 .91975 L
.68836 .91581 L
.70106 .91111 L
.71376 .90565 L
.72646 .89943 L
.73915 .89244 L
.75185 .8847 L
.76455 .87619 L
.77725 .86692 L
.78995 .85689 L
.80265 .8461 L
.81534 .83454 L
.82804 .82222 L
s
.6285 .91435 m
.64145 .9137 L
.65441 .91228 L
.66737 .91007 L
.68033 .90709 L
.69328 .90334 L
.70624 .8988 L
.7192 .89349 L
.73216 .8874 L
.74511 .88053 L
.75807 .87289 L
.77103 .86446 L
.78399 .85526 L
.79694 .84529 L
.8099 .83453 L
.82286 .823 L
s
.61905 .8996 m
.63228 .9 L
.6455 .8996 L
.65873 .89841 L
.67196 .89643 L
.68519 .89365 L
.69841 .89008 L
.71164 .88571 L
.72487 .88056 L
.7381 .8746 L
.75132 .86786 L
.76455 .86032 L
.77778 .85198 L
.79101 .84286 L
.80423 .83294 L
.81746 .82222 L
s
.6092 .88261 m
.62271 .88409 L
.63622 .88477 L
.64972 .88463 L
.66323 .88369 L
.67674 .88193 L
.69025 .87937 L
.70376 .87599 L
.71727 .8718 L
.73078 .8668 L
.74429 .86099 L
.7578 .85437 L
.7713 .84694 L
.78481 .8387 L
.79832 .82965 L
.81183 .81979 L
s
.59892 .86322 m
.61272 .86584 L
.62652 .86763 L
.64033 .8686 L
.65413 .86874 L
.66793 .86805 L
.68173 .86653 L
.69554 .86418 L
.70934 .86101 L
.72314 .857 L
.73695 .85217 L
.75075 .84651 L
.76455 .84003 L
.77835 .83271 L
.79216 .82457 L
.80596 .8156 L
s
.58818 .84127 m
.60229 .84508 L
.6164 .84804 L
.63051 .85016 L
.64462 .85143 L
.65873 .85185 L
.67284 .85143 L
.68695 .85016 L
.70106 .84804 L
.71517 .84508 L
.72928 .84127 L
.74339 .83661 L
.7575 .83111 L
.7716 .82476 L
.78571 .81757 L
.79982 .80952 L
s
.57696 .81659 m
.59139 .82165 L
.60582 .82583 L
.62025 .82915 L
.63468 .8316 L
.64911 .83319 L
.66354 .83391 L
.67797 .83377 L
.6924 .83276 L
.70683 .83088 L
.72126 .82814 L
.73569 .82453 L
.75012 .82006 L
.76455 .81472 L
.77898 .80851 L
.79341 .80144 L
s
.56521 .789 m
.57998 .79535 L
.59475 .80081 L
.60951 .80539 L
.62428 .80908 L
.63904 .81189 L
.65381 .81381 L
.66857 .81484 L
.68334 .81499 L
.69811 .81425 L
.71287 .81262 L
.72764 .81011 L
.7424 .80672 L
.75717 .80244 L
.77193 .79727 L
.7867 .79121 L
s
.55291 .75828 m
.56803 .76599 L
.58314 .77279 L
.59826 .77868 L
.61338 .78367 L
.6285 .78776 L
.64361 .79093 L
.65873 .7932 L
.67385 .79456 L
.68896 .79501 L
.70408 .79456 L
.7192 .7932 L
.73432 .79093 L
.74943 .78776 L
.76455 .78367 L
.77967 .77868 L
s
.65466 .9464 m
.64628 .93763 L
.63757 .92698 L
.6285 .91435 L
.61905 .8996 L
.6092 .88261 L
.59892 .86322 L
.58818 .84127 L
.57696 .81659 L
.56521 .789 L
.55291 .75828 L
s
.66687 .94286 m
.65873 .93501 L
.65026 .92533 L
.64145 .9137 L
.63228 .9 L
.62271 .88409 L
.61272 .86584 L
.60229 .84508 L
.59139 .82165 L
.57998 .79535 L
.56803 .76599 L
s
.67908 .93858 m
.67118 .93165 L
.66296 .92292 L
.65441 .91228 L
.6455 .8996 L
.63622 .88477 L
.62652 .86763 L
.6164 .84804 L
.60582 .82583 L
.59475 .80081 L
.58314 .77279 L
s
.69129 .93358 m
.68363 .92754 L
.67566 .91975 L
.66737 .91007 L
.65873 .89841 L
.64972 .88463 L
.64033 .8686 L
.63051 .85016 L
.62025 .82915 L
.60951 .80539 L
.59826 .77868 L
s
.7035 .92784 m
.69608 .92269 L
.68836 .91581 L
.68033 .90709 L
.67196 .89643 L
.66323 .88369 L
.65413 .86874 L
.64462 .85143 L
.63468 .8316 L
.62428 .80908 L
.61338 .78367 L
s
.71571 .92137 m
.70853 .91709 L
.70106 .91111 L
.69328 .90334 L
.68519 .89365 L
.67674 .88193 L
.66793 .86805 L
.65873 .85185 L
.64911 .83319 L
.63904 .81189 L
.6285 .78776 L
s
.72792 .91416 m
.72098 .91074 L
.71376 .90565 L
.70624 .8988 L
.69841 .89008 L
.69025 .87937 L
.68173 .86653 L
.67284 .85143 L
.66354 .83391 L
.65381 .81381 L
.64361 .79093 L
s
.74013 .90623 m
.73343 .90364 L
.72646 .89943 L
.7192 .89349 L
.71164 .88571 L
.70376 .87599 L
.69554 .86418 L
.68695 .85016 L
.67797 .83377 L
.66857 .81484 L
.65873 .7932 L
s
.75234 .89756 m
.74588 .8958 L
.73915 .89244 L
.73216 .8874 L
.72487 .88056 L
.71727 .8718 L
.70934 .86101 L
.70106 .84804 L
.6924 .83276 L
.68334 .81499 L
.67385 .79456 L
s
.76455 .88816 m
.75833 .88721 L
.75185 .8847 L
.74511 .88053 L
.7381 .8746 L
.73078 .8668 L
.72314 .857 L
.71517 .84508 L
.70683 .83088 L
.69811 .81425 L
.68896 .79501 L
s
.77676 .87802 m
.77077 .87787 L
.76455 .87619 L
.75807 .87289 L
.75132 .86786 L
.74429 .86099 L
.73695 .85217 L
.72928 .84127 L
.72126 .82814 L
.71287 .81262 L
.70408 .79456 L
s
.78897 .86716 m
.78322 .86779 L
.77725 .86692 L
.77103 .86446 L
.76455 .86032 L
.7578 .85437 L
.75075 .84651 L
.74339 .83661 L
.73569 .82453 L
.72764 .81011 L
.7192 .7932 L
s
.80118 .85556 m
.79567 .85696 L
.78995 .85689 L
.78399 .85526 L
.77778 .85198 L
.7713 .84694 L
.76455 .84003 L
.7575 .83111 L
.75012 .82006 L
.7424 .80672 L
.73432 .79093 L
s
.81339 .84322 m
.80812 .84538 L
.80265 .8461 L
.79694 .84529 L
.79101 .84286 L
.78481 .8387 L
.77835 .83271 L
.7716 .82476 L
.76455 .81472 L
.75717 .80244 L
.74943 .78776 L
s
.8256 .83016 m
.82057 .83305 L
.81534 .83454 L
.8099 .83453 L
.80423 .83294 L
.79832 .82965 L
.79216 .82457 L
.78571 .81757 L
.77898 .80851 L
.77193 .79727 L
.76455 .78367 L
s
.83781 .81636 m
.83302 .81998 L
.82804 .82222 L
.82286 .823 L
.81746 .82222 L
.81183 .81979 L
.80596 .8156 L
.79982 .80952 L
.79341 .80144 L
.7867 .79121 L
.77967 .77868 L
s
[ .01 .01 ] 0 setdash
.47151 .65324 m
.83781 .65324 L
s
.71164 .7672 m
.55291 .44974 L
s
.32615 .44974 m
.77967 .44974 L
.87037 .7672 L
s
.65466 .65324 m
.65466 .9464 L
s
.83781 .65324 m
.83781 .81636 L
s
.55291 .44974 m
.55291 .75828 L
s
.77967 .44974 m
.77967 .77868 L
s
0 0 m
1 0 L
1 1.11111 L
0 1.11111 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{259.188, 287.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004300017b000`400?l00000o`00003oo`3oool4
0?ooo`00o`3oool40?ooo`00o`3oool40?ooo`00o`3oool40?ooo`00o`3oool40?ooo`00o`3oool4
0?ooo`001P3oool00`000000oooo0?ooo`3j0?ooo`001`3oool00`000000oooo0?ooo`3i0?ooo`00
1`3oool200000?X0oooo00080?ooo`030000003oool0oooo0?P0oooo00080?ooo`800000n@3oool0
00T0oooo0P00003h0?ooo`002P3oool200000?L0oooo000:0?ooo`800000m`3oool000/0oooo0P00
003f0?ooo`002`3oool300000?D0oooo000<0?ooo`<00000m03oool000`0oooo00<000000?ooo`00
0000m03oool000d0oooo0`00003c0?ooo`003P3oool300000?80oooo000>0?ooo`040000003oool0
000000000?40oooo000?0?ooo`040000003oool0000000000?00oooo000?0?ooo`040000003oool0
000000000?00oooo000@0?ooo`040000003oool0000000000>l0oooo000A0?ooo`040000003oool0
000000000>h0oooo000A0?ooo`050000003oool000000?ooo`000000k@3oool00180oooo00@00000
0?ooo`0000000000k@3oool00180oooo00<000000?ooo`3oool00P00003/0?ooo`004`3oool00`00
0000oooo0?ooo`0200000>/0oooo000F0?ooo`030000003oool0oooo0>X0oooo000G0?ooo`030000
003oool0oooo0>T0oooo000H0?ooo`030000003oool0oooo0>P0oooo000H0?ooo`030000003oool0
oooo0>P0oooo000I0?ooo`030000003oool0oooo0>L0oooo000J0?ooo`030000003oool0oooo0>H0
oooo000K0?ooo`030000003oool0oooo0>D0oooo000K0?ooo`030000003oool0oooo0>D0oooo000L
0?ooo`030000003oool0oooo0>@0oooo000M0?ooo`030000003oool0oooo0><0oooo000M0?ooo`03
0000003oool0oooo0><0oooo000N0?ooo`030000003oool0oooo0>80oooo000O0?ooo`030000003o
ool0oooo0>40oooo000O0?ooo`030000003oool0oooo0>40oooo000P0?ooo`030000003oool0oooo
0>00oooo000Q0?ooo`030000003oool0oooo0=l0oooo000R0?ooo`030000003oool0oooo0=h0oooo
000R0?ooo`030000003oool0oooo0=h0oooo000S0?ooo`030000003oool0oooo0=d0oooo000T0?oo
o`030000003oool0oooo0=`0oooo000T0?ooo`030000003oool0oooo0=`0oooo000U0?ooo`030000
003oool0oooo0=/0oooo000V0?ooo`030000003oool0oooo0=X0oooo000W0?ooo`030000003oool0
oooo0=T0oooo000W0?ooo`030000003oool0oooo0=T0oooo000X0?ooo`030000003oool0oooo0=P0
oooo000Y0?ooo`030000003oool0oooo0=L0oooo000Y0?ooo`030000003oool0oooo0=L0oooo000Z
0?ooo`030000003oool0oooo0=H0oooo000[0?ooo`030000003oool0oooo0=D0oooo000/0?ooo`03
0000003oool0oooo0=@0oooo000/0?ooo`030000003oool0oooo0=@0oooo000]0?ooo`030000003o
ool0oooo0=<0oooo000^0?ooo`030000003oool0oooo0=80oooo000^0?ooo`030000003oool0oooo
0=80oooo000_0?ooo`030000003oool0oooo0=40oooo000`0?ooo`030000003oool0oooo0=00oooo
000`0?ooo`030000003oool0oooo0=00oooo000a0?ooo`030000003oool0oooo0<l0oooo000b0?oo
o`030000003oool0oooo0<h0oooo000c0?ooo`030000003oool0oooo0<d0oooo000c0?ooo`030000
003oool0oooo0<d0oooo000d0?ooo`030000003oool0oooo0<`0oooo000e0?ooo`030000003oool0
oooo0</0oooo000e0?ooo`030000003oool0oooo0</0oooo000f0?ooo`030000003oool0oooo0<X0
oooo000g0?ooo`030000003oool0oooo0<T0oooo000h0?ooo`030000003oool0oooo0<P0oooo000h
0?ooo`030000003oool0oooo0<P0oooo000i0?ooo`030000003oool0oooo0<L0oooo000j0?ooo`03
0000003oool0oooo0<H0oooo000j0?ooo`030000003oool0oooo0<H0oooo000k0?ooo`030000003o
ool0oooo0<D0oooo000l0?ooo`030000003oool0oooo0<@0oooo000m0?ooo`030000003oool0oooo
0<<0oooo000m0?ooo`030000003oool0oooo0<<0oooo000n0?ooo`030000003oool0oooo0<80oooo
000o0?ooo`030000003oool0oooo0<40oooo000o0?ooo`030000003oool0oooo0<40oooo00100?oo
o`030000003oool0oooo0<00oooo00110?ooo`030000003oool0oooo0;l0oooo00110?ooo`030000
003oool0oooo0;l0oooo00120?ooo`030000003oool0oooo0;h0oooo00130?ooo`030000003oool0
oooo0;d0oooo00140?ooo`030000003oool0oooo0;`0oooo00140?ooo`030000003oool0oooo0;`0
oooo00150?ooo`030000003oool0oooo0;/0oooo00160?ooo`030000003oool0oooo0;X0oooo0016
0?ooo`030000003oool0oooo0;X0oooo00170?ooo`030000003oool0oooo0;T0oooo00180?ooo`03
0000003oool0oooo0;P0oooo00190?ooo`030000003oool0oooo0;L0oooo00190?ooo`030000003o
ool0oooo0;L0oooo001:0?ooo`030000003oool0oooo0;H0oooo001;0?ooo`030000003oool0oooo
0;D0oooo001;0?ooo`030000003oool0oooo0;D0oooo001<0?ooo`030000003oool0oooo0;@0oooo
001=0?ooo`030000003oool0oooo0;<0oooo001>0?ooo`030000003oool0oooo0;80oooo001>0?oo
o`030000003oool0oooo0;80oooo001?0?ooo`030000003oool0oooo0;40oooo001@0?ooo`030000
003oool0oooo0;00oooo001@0?ooo`030000003oool0oooo0;00oooo001A0?ooo`030000003oool0
oooo0:l0oooo001B0?ooo`030000003oool0oooo0:h0oooo001B0?ooo`030000003oool0oooo0:h0
oooo001C0?ooo`030000003oool0oooo0:d0oooo001D0?ooo`<000000P3oool300000080oooo1000
00000`3oool0000000000002000000030?ooo`0000000000008000000P3oool300000080oooo0`00
00020?ooo`<000000P3oool4000000030?ooo`00000000000080000000<0oooo0000000000000P00
00000`3oool000000000000200000080oooo0`0000020?ooo`<000000P3oool4000000030?ooo`00
000000000080000000<0oooo0000000000000P0000000`3oool000000000000200000080oooo0`00
00020?ooo`<000000P3oool4000000030?ooo`00000000000080000000<0oooo0000000000000`00
000i0?ooo`00E@3oool00`000000oooo0?ooo`0f0?ooo`800000>@3oool00`000000oooo0?ooo`0g
0?ooo`00E@3oool00`000000oooo0?ooo`0f0?ooo`800000>@3oool00`000000oooo0?ooo`0g0?oo
o`00EP3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3o
ool0=P3oool005L0oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`0f0?ooo`00E`3o
ool00`000000oooo0?ooo`0d0?ooo`040000003oool0oooo000003L0oooo00<000000?ooo`3oool0
=`3oool005P0oooo00<000000?ooo`3oool0<`3oool010000000oooo0?ooo`00000g0?ooo`030000
003oool0000003L0oooo001I0?ooo`030000003oool0oooo0380oooo00D000000?ooo`3oool0oooo
0000000f0?ooo`030000003oool0000003L0oooo001J0?ooo`030000003oool0oooo03D0oooo00<0
00000?ooo`3oool0=P3oool00`000000oooo0?ooo`0e0?ooo`00FP3oool00`000000oooo0?ooo`1^
0?ooo`030000003oool0oooo03D0oooo001K0?ooo`030000003oool0oooo0300oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo03L0oooo001L0?ooo`03
0000003oool0oooo02l0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0b0?ooo`04
0000003oool0oooo000003H0oooo001L0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0a0?ooo`040000003oool0oooo000003H0oooo001M0?ooo`03
0000003oool0oooo02h0oooo00<000000?ooo`3oool0>03oool01@000000oooo0?ooo`3oool00000
03D0oooo001N0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0<`3oool005l0oooo
00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0300oooo
00<000000?ooo`3oool0=`3oool005l0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0300oooo00D000000?ooo`3oool0oooo0000000e0?ooo`00H03o
ool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0;`3o
ool01@000000oooo0?ooo`3oool0000003D0oooo001Q0?ooo`030000003oool0oooo02X0oooo00<0
00000?ooo`3oool0>03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0380oooo001Q
0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0b
0?ooo`00HP3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0;P3oool00`000000oooo0?ooo`0g0?ooo`00H`3oool00`000000oooo0?ooo`0X0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0340oooo001S0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
<@3oool006@0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0h0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0<03oool006D0oooo00<000000?ooo`3oool0<P3oool0
0`000000oooo0?ooo`0c0?ooo`030000003oool0oooo0300oooo001V0?ooo`030000003oool0oooo
0340oooo00<000000?ooo`3oool0IP3oool006H0oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0`0?ooo`00I`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo03P0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0`0?ooo`00J03oool00`000000oooo0?oo
o`0S0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0_0?ooo`00J03oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo0340oooo00<00000
0?ooo`3oool0;`3oool006T0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`1S0?oo
o`00JP3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0:03oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo02h0oooo001[0?ooo`030000
003oool0oooo0200oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo02h0oooo001[0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0;P3o
ool006`0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0`0?ooo`030000003oool0
oooo02h0oooo001]0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0H03oool006d0
oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0;@3oool006h0oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`0h0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0;@3oool006l0oooo00<0
00000?ooo`3oool0703oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0/0?ooo`00L03oool00`000000oooo0?ooo`0^
0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0;03oool00700oooo00<000000?oo
o`3oool0;`3oool00`000000oooo0?ooo`1N0?ooo`00L@3oool00`000000oooo0?ooo`0J0?ooo`03
0000003oool0oooo03P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0[0?ooo`00
LP3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
8P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02/0oooo001b0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0R0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0:`3oool007<0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0[0?ooo`00M03oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo
05/0oooo001d0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0>03oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo02X0oooo001e0?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0:P3oool007H0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0Y0?ooo`00M`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool07`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02T0oooo001g0?oo
o`030000003oool0oooo08T0oooo001h0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3o
ool0>03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02T0oooo001i0?ooo`@00000
00<0oooo0000000000000P0000020?ooo`<000000P3oool300000080oooo0`0000020?ooo`@00000
00<0oooo0000000000000P0000000`3oool0000000000002000000030?ooo`000000000000800000
0P3oool300000080oooo0`0000020?ooo`@0000000<0oooo0000000000000P0000000`3oool00000
00000002000000030?ooo`0000000000008000000P3oool300000080oooo0`0000020?ooo`@00000
00@0oooo0000000000000000:P3oool007T0oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`0G0?ooo`8000007`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02P0oooo
001j0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0M0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0:03oool007/0oooo00<00000
0?ooo`3oool0:`3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo02P0oooo001l0?oo
o`030000003oool0oooo02/0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0W0?oo
o`00O03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`00
00007@3oool00`000000oooo0?ooo`0<0?ooo`800000:@3oool007d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0000001d0oooo00<000000?ooo`3oool0
303oool00`000000oooo0000000X0?ooo`00OP3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo01P0oooo00@000000?ooo`3oool00000703oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo02P0oooo001n0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0;03o
ool00`000000oooo0?ooo`0X0?ooo`00O`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0
oooo02X0oooo00<000000?ooo`3oool09P3oool00800oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0L0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0V0?ooo`00P@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00`0
oooo00@000000?ooo`3oool000009`3oool00840oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0X0?ooo`00PP3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo02`0oooo
00<000000?ooo`3oool0:03oool008<0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?oo
o`0Z0?ooo`030000003oool0oooo02@0oooo00230?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool07P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0903oool008@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0<0?oo
o`050000003oool0oooo0?ooo`0000009P3oool008D0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0X0?ooo`00Q@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0X0?ooo`00QP3oool00`000000oooo
0?ooo`0Y0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool08`3oool008L0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0S0?ooo`00R03oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool08P3oool008P0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01d0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0X0?ooo`00R@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0:03oool008X0oooo00<000000?ooo`3oool0
703oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0Q0?ooo`00RP3oool01@000000oooo0?ooo`3oool0000002H0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0240oooo
002;0?ooo`040000003oool0oooo000001X0oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool08@3oool008`0oooo00<0
00000?ooo`0000006P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0X0?ooo`00S@3oool4000001P0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0:03oool008d0oooo00@000000?ooo`000000oooo0P00000F0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo01@0oooo0`0000090?ooo`00SP3ooom_000000H0oooo002>0?ooo`8000000`3oool010000000
oooo00000000000B0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0L0?ooo`<000002@3oool008h0oooo00<000000?ooo`0000000P3oool00`000000
oooo0?ooo`0300000100oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo02P0oooo002>0?ooo`030000003oool000000080oooo00H000000?ooo`3oool0
oooo0000003oool3000000d0oooo00<000000?ooo`3oool0703oool2000000h0oooo00<000000?oo
o`3oool0:03oool008h0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`000002
0?ooo`030000003oool0000000<000002@3oool00`000000oooo0?ooo`0H0?ooo`@000000P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02P0oooo002>0?ooo`040000003oool0oooo
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0000003oool0
1000000L0?ooo`@000000P3oool01@000000oooo0?ooo`3oool0000003P0oooo002>0?ooo`030000
003oool0oooo00<0000000D0oooo0000003oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo00000007000000`0oooo200000000`3oool000000?ooo`030?oo
o`040000003oool0oooo0?ooo`800000303oool00`000000oooo0?ooo`0X0?ooo`00SP3oool01P00
0000oooo0?ooo`3oool000000?ooo`<000000P3oool010000000oooo0?ooo`0000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`02000000030?ooo`000000000000X0
000000<0oooo0000003oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080
oooo0`0000000`3oool000000?ooo`0;0?ooo`030000003oool0oooo02P0oooo002>0?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0000000200000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool000000080oooo
00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@00
0000oooo0?ooo`3oool000000080oooo0P0000000`3oool000000?ooo`020?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0:03oool008h0oooo00<000000?ooo`3oool00P3oool01000
0000oooo0?ooo`0000020?ooo`<0000000D0oooo0000003oool0oooo000000020?ooo`090000003o
ool0oooo0?ooo`000000oooo0000003oool000000080oooo00D000000?ooo`3oool0oooo00000003
0?ooo`050000003oool0oooo0?ooo`0000000`3oool010000000oooo0?ooo`3oool3000000<0oooo
00<000000?ooo`3oool00P00000;0?ooo`030000003oool0oooo02P0oooo002>0?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool000000`3oool00`000000oooo00000006000000050?oo
o`000000oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0oooo00@000000P3oool00`000000oooo0?ooo`02
0?ooo`8000000P3oool00`000000oooo0?ooo`0c0?ooo`00SP3oool00`000000oooo0?ooo`030?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0000
000200000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00000`3oool700000080oooo00D000000?ooo`3oool0oooo000000020?ooo`<00000103oool00`00
0000oooo0?ooo`0b0?ooo`00SP3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo0000
00<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0000003ooolA000000030?ooo`00
0000oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`<000000`3oool01@000000oooo
000000000000oooo008000001`3oool00`000000oooo0?ooo`0X0?ooo`00SP3oool00`000000oooo
0?ooo`030?ooo`<0000000D0oooo0000003oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3oool000000`3o
ool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000<0oooo100000020?ooo`040000
003oool0oooo0?ooo`8000000P3oool2000000030?ooo`000000oooo00@0oooo00<000000?ooo`3o
ool0:@3oool008h0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000200000080oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo
0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool01000
00020?ooo`060000003oool0oooo0?ooo`000000oooo0P000000103oool000000000000000020?oo
o`030000003oool0000000@00000;03oool008h0oooo00<000000?ooo`3oool0103oool01@000000
oooo0?ooo`000000oooo00@0000000<0oooo0000003oool00P3oool010000000oooo0?ooo`000003
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo
0`0000000`3oool000000?ooo`030?ooo`040000003oool0oooo0?ooo`8000000`3oool01@000000
oooo0000003oool000000080oooo1@00000/0?ooo`00SP3oool00`000000oooo0?ooo`050?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`0000001P0000000`3oool000000?ooo`020?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`04000000030?ooo`000000
oooo0080oooo00<000000?ooo`3oool00P3oool3000000030?ooo`000000oooo008000000`3oool0
0`000000oooo00000005000002d0oooo002>0?ooo`030000003oool0oooo00D0oooo00@000000?oo
o`3oool000000`3oool010000000oooo0?ooo`0000030?oooa40000000<0oooo0000003oool00`3o
ool010000000oooo0?ooo`0000020?ooo`80000000@0oooo0000003oool0oooo0P0000030?ooo`80
000000<0oooo0000000000001000000^0?ooo`00SP3oool00`000000oooo0?ooo`060?ooo`040000
003oool0oooo00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo
0?ooo`80000000<0oooo0000003oool00P3oool01@000000oooo0?ooo`3oool0000000<0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`<00000103oool200000080oooo0`000000103oool00000
0000003oool4000002l0oooo002>0?ooo`030000003oool0oooo00H0oooo0P0000000`3oool00000
0?ooo`020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00P0000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo0`000002
0?ooo`030000003oool0oooo0080000000<0oooo0000003oool00P000000103oool000000000003o
ool500000300oooo002>0?ooo`030000003oool0oooo00L0oooo1@0000000`3oool000000?ooo`02
0?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool01@000000oooo
0?ooo`3oool000000080oooo100000020?ooo`040000003oool0oooo0?ooo`800000103oool01P00
0000oooo0?ooo`3oool000000?ooo`D00000<@3oool008h0oooo00<000000?ooo`3oool01`3oool0
10000000oooo0?ooo`3oool<000000040?ooo`000000oooo0?ooo`/000000P3oool01P000000oooo
0?ooo`3oool000000?ooo`80000000@0oooo0000003oool0oooo0`0000000`3oool0000000000002
000000040?ooo`000000000000000380oooo002>0?ooo`030000003oool0oooo00P0oooo00@00000
0?ooo`3oool000000P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`000000
0`0000020?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool000000`3oool20000
00@0oooo0P0000030?ooo`<0000000@0oooo0000000000000000=03oool008h0oooo00<000000?oo
o`3oool0203oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000`3o
ool010000000oooo0000000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`0400000080oooo00L000000?ooo`00000000000?ooo`000000oooo0080000000<0oooo
0000003oool00`00000e0?ooo`00SP3oool00`000000oooo0?ooo`090?ooo`80000000D0oooo0000
003oool0oooo000000030?ooo`080000003oool0oooo0000003oool000000?ooo`0000030?ooo`04
0000003oool0oooo000000<0oooo0`0000020?ooo`040000003oool0oooo0?ooo`800000103oool0
0`000000oooo0?ooo`03000000030?ooo`000000oooo03D0oooo002>0?ooo`030000003oool0oooo
00X0oooo1@0000001@3oool000000?ooo`3oool0000000<0oooo0P0000000`3oool000000?ooo`02
0?ooo`L000000P3oool010000000oooo0?ooo`3oool3000000040?ooo`000000oooo0?ooo`800000
00@0oooo00000000000000000P3oool00`000000oooo0?ooo`0e0?ooo`00SP3oool00`000000oooo
0?ooo`0:0?ooo`050000003oool0oooo0000003oool03`0000000`3oool000000?ooo`020?ooo`06
0000003oool0oooo0?ooo`000000oooo0P000000103oool000000?ooo`3oool300000080oooo0`00
00000`3oool000000000000h0?ooo`00SP3oool00`000000oooo0?ooo`0;0?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool0000000<0
oooo00@000000?ooo`3oool000000`3oool2000000@0oooo0P0000020?ooo`<0000000<0oooo0000
003oool00P00000i0?ooo`00SP3oool00`000000oooo0?ooo`0;0?ooo`040000003oool0oooo0000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3o
ool00`000000oooo0?ooo`0400000080oooo00L000000?ooo`00000000000?ooo`000000oooo0080
000000<0oooo0000000000000`00000j0?ooo`00SP3oool00`000000oooo0?ooo`0<0?ooo`800000
00D0oooo0000003oool0oooo000000020?ooo`030000003oool0oooo008000000P3oool700000080
oooo00@000000?ooo`3oool0oooo0P0000040?ooo`030000003oool0oooo0080000000<0oooo0000
00000000>`3oool008h0oooo00<000000?ooo`3oool0303oool00`000000oooo0000000=00000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`@000000P3oool01@000000oooo000000000000
oooo0080000000@0oooo0000000000000000?03oool008h0oooo00<000000?ooo`3oool03@3oool0
10000000oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000000`3oool010000000oooo
0?ooo`0000030?ooo`<000000P3oool010000000oooo0?ooo`3oool200000080oooo0P000000103o
ool0000000000000000m0?ooo`00SP3oool00`000000oooo0?ooo`0=0?ooo`040000003oool0oooo
000000<0oooo00<000000?ooo`3oool00P0000020?ooo`030000003oool0oooo00@000000P3oool0
10000000oooo0?ooo`3oool300000080oooo0P0000000`3oool0000000000002000003h0oooo002>
0?ooo`030000003oool0oooo00h0oooo00@000000?ooo`3oool000000P3oool01@000000oooo0?oo
o`3oool000000080oooo0`0000020?ooo`060000003oool0oooo0?ooo`000000oooo0P0000000`3o
ool000000?ooo`02000000030?ooo`000000000000800000@03oool008h0oooo00<000000?ooo`3o
ool03P3oool=00000080oooo00@000000?ooo`3oool000000`3oool2000000<0oooo0P0000020?oo
o`80000000<0oooo0000003oool0@03oool008h0oooo00<000000?ooo`3oool03`3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`000000oooo000000020?ooo`030000003oool0
oooo00@000000P3oool300000080oooo0P0000020?ooo`030000003oool0oooo0400oooo002>0?oo
o`030000003oool0oooo00l0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000P3oool300000080oooo0P0000001P3oool000000000003oool000000?ooo`80
000000<0oooo000000000000@`3oool008h0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0:00000080oooo00@000000?ooo`3oool0oooo0P0000030?ooo`8000000P3oool2000004@0
oooo002>0?ooo`030000003oool0oooo0140oooo0P0000020?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`3oool0100000020?ooo`<0000000@0oooo0000000000000000AP3oool008h0
oooo00<000000?ooo`3oool04P3oool010000000oooo0?ooo`0000020?ooo`8000000P3oool30000
0080oooo00D000000?ooo`00000000000?ooo`03000004T0oooo002>0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool01`0000020?ooo`030000003oool0oooo008000000P3oool20000
04/0oooo002>0?ooo`030000003oool0oooo01<0oooo0P0000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool300000080oooo0P00001=0?ooo`00SP3oool00`000000oooo0?ooo`0D0?ooo`05
0000003oool0oooo0?ooo`0000000P3oool300000080oooo00@000000?ooo`0000000000CP3oool0
08h0oooo00<000000?ooo`3oool0503oool010000000oooo0?ooo`3oool300000080oooo00<00000
0?ooo`3oool00P00001@0?ooo`00SP3oool00`000000oooo0?ooo`0E0?ooo`@0000000@0oooo0000
003oool0oooo0`00001B0?ooo`00SP3oool00`000000oooo0?ooo`0F0?ooo`<0000000@0oooo0000
000000000000E@3oool008h0oooo00<000000?ooo`3oool0603oool2000005P0oooo002>0?ooo`03
0000003oool0oooo0780oooo002>0?ooo`030000003oool0oooo0780oooo002>0?ooo`030000003o
ool0oooo0780oooo002>0?ooo`030000003oool0oooo0780oooo002>0?ooo`030000003oool0oooo
0780oooo002>0?ooo`030000003oool0oooo0780oooo002>0?ooo`030000003oool0oooo0780oooo
002>0?ooo`030000003oool0oooo0780oooo002>0?ooo`030000003oool0oooo0780oooo002>0?oo
o`030000003oool0oooo0780oooo002>0?ooo`030000003oool0oooo0780oooo002>0?ooo`030000
003oool0oooo0780oooo002>0?ooo`030000003oool0oooo0780oooo002>0?ooo`030000003oool0
oooo0780oooo002>0?ooo`030000003oool0oooo0780oooo002>0?ooo`030000003oool0oooo0780
oooo002>0?ooo`030000003oool0oooo0780oooo002>0?ooo`030000003oool0oooo0780oooo002>
0?ooo`030000003oool0oooo0780oooo002>0?ooo`030000003oool0oooo0780oooo002>0?ooo`03
0000003oool0oooo0780oooo002>0?ooo`030000003oool0oooo0780oooo002>0?ooo`030000003o
ool0oooo0780oooo002>0?ooo`030000003oool0oooo0780oooo002>0?ooo`030000003oool0oooo
0780oooo002>0?ooo`030000003oool0oooo0780oooo002>0?ooo`030000003oool0oooo0780oooo
002>0?ooo`030000003oool0oooo0780oooo002>0?ooo`030000003oool0oooo0780oooo002=0?oo
o`<00000L`3oool008d0oooo0`00001c0?ooo`00S@3oool3000007<0oooo002=0?ooo`800000M03o
ool008h0oooo00<000000?ooo`3oool0LP3oool008h0oooo00<000000?ooo`3oool0LP3oool008h0
oooo00<000000?ooo`3oool0LP3oool00?l0oooo103oool00?l0oooo103oool00?l0oooo103oool0
0?l0oooo103oool00?l0oooo103oool00?l0oooo103oool00001\
\>"],
  ImageRangeCache->{{{0, 258.188}, {286.938, 0}} -> {3.29582, 4.6248, \
0.00610028, 0.00610028}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
WindowSize->{971, 924},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1592, 29, 330, "Input"],
Cell[3349, 82, 1013, 19, 190, "Input"],

Cell[CellGroupData[{
Cell[4387, 105, 131, 2, 30, "Input"],
Cell[4521, 109, 32895, 790, 296, 6755, 463, "GraphicsData", "PostScript", \
"Graphics"],
Cell[37419, 901, 130, 3, 29, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

