(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     36262,        891]*)
(*NotebookOutlinePosition[     36969,        915]*)
(*  CellTagsIndexPosition[     36925,        911]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(\(FX[x_, y_, z_] := y - \((x/\@2)\)\ ;\)\), "\n", 
    \(\(FY[x_, y_, z_] := z - \((x/\@2)\);\)\), "\n", 
    \(xma = 3; yma = 4; zma = 3;\), "\n", 
    \(xxd = Abs[FX[0, yma, 0] - FX[xma, 0, 0]]; 
    yyd = Abs[
        FY[0, 0, zma] - 
          Min[FY[xma, 0, 0], FY[0, yma, 0]]];\), "\[IndentingNewLine]", 
    \(ar = yyd/xxd; wx = xxd/50; hx = 0.2*wx;\), "\[IndentingNewLine]", 
    \(wz = yyd/50; hz = wz*0.2; wy = wx; hy = hz; 
    LX = {Thickness[
          0.00402], {Line[{{FX[0, 0, 0], FY[0, 0, 0]}, {FX[xma, 0, 0], 
                FY[xma, 0, 0]}}]}, {Line[{{FX[xma - wx, hx, 0], 
                FY[xma - wx, hx, 0]}, {FX[xma, 0, 0], 
                FY[xma, 0, 0]}, {FX[xma - wx, \(-hx\), 0], 
                FY[xma - wx, \(-hx\), 0]}}]}}; 
    LY = {Thickness[
          0.00402], {Line[{{FX[0, 0, 0], FY[0, 0, 0]}, {FX[0, yma, 0], 
                FY[0, yma, 0]}}]}, {Line[{{FX[0, yma - wy, hy], 
                FY[0, yma - wy, hy]}, {FX[0, yma, 0], 
                FY[0, yma, 0]}, {FX[0, yma - wy, \(-hy\)], 
                FY[0, yma - wy, \(-hy\)]}}]}};\), "\n", 
    \(\(LZ = {Thickness[
            0.00402], {Line[{{FX[0, 0, 0], FY[0, 0, 0]}, {FX[0, 0, zma], 
                  FY[0, 0, zma]}}]}, {Line[{{FX[0, hz, zma - wz], 
                  FY[0, hz, zma - wz]}, {FX[0, 0, zma], 
                  FY[0, 0, zma]}, {FX[0, \(-hz\), zma - wz], 
                  FY[0, \(-hz\), zma - wz]}}]}};\)\)}], "Input"],

Cell[BoxData[{
    \(\(f[x_, y_] := 2.5 - 0.6*x^2 + 0.8*x*y - 0.3*y^2;\)\), "\n", 
    \(x1 = 0.8; x2 = 1.8; y1 = 1.5; y2 = 3;\), "\n", 
    \(\(fG = {Table[
            Line[Table[{FX[x, y, f[x, y]], FY[x, y, f[x, y]]}, {y, y1, y2, 
                  0.1}]], {x, x1, x2, 0.1}], 
          Table[Line[
              Table[{FX[x, y, f[x, y]], FY[x, y, f[x, y]]}, {x, x1, x2, 
                  0.1}]], {y, y1, y2, 0.1}]};\)\), "\n", 
    \(DL1 = {Dashing[{0.01, 
            0.01}], {Line[{{FX[x1, 0, 0], FY[x1, 0, 0]}, {FX[x1, y2, 0], 
                FY[x1, y2, 0]}}], 
          Line[{{FX[0, y1, 0], FY[0, y1, 0]}, {FX[x2, y1, 0], 
                FY[x2, y1, 0]}}], 
          Line[{{FX[x2, 0, 0], FY[x2, 0, 0]}, {FX[x2, y2, 0], 
                FY[x2, y2, 0]}, {FX[0, y2, 0], FY[0, y2, 0]}}]}}; 
    DL2 = {Dashing[{0.01, 0.01}], 
        Table[Line[{{FX[x, y, 0], FY[x, y, 0]}, {FX[x, y, f[x, y]], 
                FY[x, y, f[x, y]]}}], {x, x1, x2, x2 - x1}, {y, y1, y2, 
            y2 - y1}]};\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[{LX, LY, LZ, fG, DL1, DL2}], 
      AspectRatio \[Rule] Automatic, PlotRange -> All]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .83664 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.353854 0.155584 0.349964 0.155584 [
[ 0 0 0 0 ]
[ 1 .83664 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.00402 w
[ ] 0 setdash
.35385 .34996 m
.02381 .01992 L
s
.04109 .03339 m
.02381 .01992 L
.03347 .03339 L
s
.35385 .34996 m
.97619 .34996 L
s
.95714 .35315 m
.97619 .34996 L
.95714 .34678 L
s
.35385 .34996 m
.35385 .81672 L
s
.35704 .80078 m
.35385 .81672 L
.35067 .80078 L
s
.5 Mabswid
.49922 .63551 m
.51478 .631 L
.53033 .62555 L
.54589 .61917 L
.56145 .61186 L
.57701 .60362 L
.59257 .59444 L
.60813 .58432 L
.62369 .57328 L
.63924 .5613 L
.6548 .54838 L
.67036 .53454 L
.68592 .51976 L
.70148 .50404 L
.71704 .48739 L
.73259 .46981 L
s
.48822 .62731 m
.50378 .62404 L
.51933 .61984 L
.53489 .61471 L
.55045 .60864 L
.56601 .60164 L
.58157 .5937 L
.59713 .58483 L
.61268 .57503 L
.62824 .5643 L
.6438 .55263 L
.65936 .54003 L
.67492 .52649 L
.69048 .51202 L
.70603 .49662 L
.72159 .48028 L
s
.47722 .61724 m
.49277 .61522 L
.50833 .61226 L
.52389 .60837 L
.53945 .60355 L
.55501 .59779 L
.57057 .5911 L
.58612 .58348 L
.60168 .57492 L
.61724 .56543 L
.6328 .55501 L
.64836 .54365 L
.66392 .53136 L
.67947 .51813 L
.69503 .50398 L
.71059 .48888 L
s
.46621 .60531 m
.48177 .60453 L
.49733 .60282 L
.51289 .60017 L
.52845 .59659 L
.54401 .59208 L
.55956 .58664 L
.57512 .58026 L
.59068 .57294 L
.60624 .5647 L
.6218 .55552 L
.63736 .54541 L
.65291 .53436 L
.66847 .52238 L
.68403 .50947 L
.69959 .49562 L
s
.45521 .5915 m
.47077 .59197 L
.48633 .5915 L
.50189 .5901 L
.51745 .58777 L
.533 .5845 L
.54856 .5803 L
.56412 .57517 L
.57968 .5691 L
.59524 .5621 L
.6108 .55416 L
.62635 .5453 L
.64191 .53549 L
.65747 .52476 L
.67303 .51309 L
.68859 .50049 L
s
.44421 .57584 m
.45977 .57755 L
.47533 .57832 L
.49089 .57817 L
.50644 .57708 L
.522 .57506 L
.53756 .5721 L
.55312 .56821 L
.56868 .56339 L
.58424 .55763 L
.5998 .55094 L
.61535 .54332 L
.63091 .53476 L
.64647 .52527 L
.66203 .51485 L
.67759 .50349 L
s
.43321 .5583 m
.44877 .56126 L
.46433 .56328 L
.47988 .56437 L
.49544 .56452 L
.511 .56374 L
.52656 .56203 L
.54212 .55939 L
.55768 .55581 L
.57324 .5513 L
.58879 .54585 L
.60435 .53947 L
.61991 .53216 L
.63547 .52391 L
.65103 .51474 L
.66659 .50462 L
s
.42221 .5389 m
.43777 .5431 L
.45332 .54636 L
.46888 .5487 L
.48444 .5501 L
.5 .55056 L
.51556 .5501 L
.53112 .5487 L
.54668 .54636 L
.56223 .5431 L
.57779 .5389 L
.59335 .53376 L
.60891 .52769 L
.62447 .52069 L
.64003 .51276 L
.65558 .50389 L
s
.41121 .51763 m
.42676 .52307 L
.44232 .52758 L
.45788 .53116 L
.47344 .53381 L
.489 .53552 L
.50456 .5363 L
.52012 .53614 L
.53567 .53505 L
.55123 .53303 L
.56679 .53007 L
.58235 .52618 L
.59791 .52136 L
.61347 .5156 L
.62902 .50891 L
.64458 .50129 L
s
.4002 .49449 m
.41576 .50118 L
.43132 .50694 L
.44688 .51176 L
.46244 .51565 L
.478 .5186 L
.49356 .52063 L
.50911 .52172 L
.52467 .52187 L
.54023 .52109 L
.55579 .51938 L
.57135 .51674 L
.58691 .51316 L
.60246 .50865 L
.61802 .5032 L
.63358 .49682 L
s
.3892 .46948 m
.40476 .47742 L
.42032 .48442 L
.43588 .49049 L
.45144 .49562 L
.467 .49982 L
.48255 .50309 L
.49811 .50542 L
.51367 .50683 L
.52923 .50729 L
.54479 .50683 L
.56035 .50542 L
.5759 .50309 L
.59146 .49982 L
.60702 .49562 L
.62258 .49049 L
s
.49922 .63551 m
.48822 .62731 L
.47722 .61724 L
.46621 .60531 L
.45521 .5915 L
.44421 .57584 L
.43321 .5583 L
.42221 .5389 L
.41121 .51763 L
.4002 .49449 L
.3892 .46948 L
s
.51478 .631 m
.50378 .62404 L
.49277 .61522 L
.48177 .60453 L
.47077 .59197 L
.45977 .57755 L
.44877 .56126 L
.43777 .5431 L
.42676 .52307 L
.41576 .50118 L
.40476 .47742 L
s
.53033 .62555 m
.51933 .61984 L
.50833 .61226 L
.49733 .60282 L
.48633 .5915 L
.47533 .57832 L
.46433 .56328 L
.45332 .54636 L
.44232 .52758 L
.43132 .50694 L
.42032 .48442 L
s
.54589 .61917 m
.53489 .61471 L
.52389 .60837 L
.51289 .60017 L
.50189 .5901 L
.49089 .57817 L
.47988 .56437 L
.46888 .5487 L
.45788 .53116 L
.44688 .51176 L
.43588 .49049 L
s
.56145 .61186 m
.55045 .60864 L
.53945 .60355 L
.52845 .59659 L
.51745 .58777 L
.50644 .57708 L
.49544 .56452 L
.48444 .5501 L
.47344 .53381 L
.46244 .51565 L
.45144 .49562 L
s
.57701 .60362 m
.56601 .60164 L
.55501 .59779 L
.54401 .59208 L
.533 .5845 L
.522 .57506 L
.511 .56374 L
.5 .55056 L
.489 .53552 L
.478 .5186 L
.467 .49982 L
s
.59257 .59444 m
.58157 .5937 L
.57057 .5911 L
.55956 .58664 L
.54856 .5803 L
.53756 .5721 L
.52656 .56203 L
.51556 .5501 L
.50456 .5363 L
.49356 .52063 L
.48255 .50309 L
s
.60813 .58432 m
.59713 .58483 L
.58612 .58348 L
.57512 .58026 L
.56412 .57517 L
.55312 .56821 L
.54212 .55939 L
.53112 .5487 L
.52012 .53614 L
.50911 .52172 L
.49811 .50542 L
s
.62369 .57328 m
.61268 .57503 L
.60168 .57492 L
.59068 .57294 L
.57968 .5691 L
.56868 .56339 L
.55768 .55581 L
.54668 .54636 L
.53567 .53505 L
.52467 .52187 L
.51367 .50683 L
s
.63924 .5613 m
.62824 .5643 L
.61724 .56543 L
.60624 .5647 L
.59524 .5621 L
.58424 .55763 L
.57324 .5513 L
.56223 .5431 L
.55123 .53303 L
.54023 .52109 L
.52923 .50729 L
s
.6548 .54838 m
.6438 .55263 L
.6328 .55501 L
.6218 .55552 L
.6108 .55416 L
.5998 .55094 L
.58879 .54585 L
.57779 .5389 L
.56679 .53007 L
.55579 .51938 L
.54479 .50683 L
s
.67036 .53454 m
.65936 .54003 L
.64836 .54365 L
.63736 .54541 L
.62635 .5453 L
.61535 .54332 L
.60435 .53947 L
.59335 .53376 L
.58235 .52618 L
.57135 .51674 L
.56035 .50542 L
s
.68592 .51976 m
.67492 .52649 L
.66392 .53136 L
.65291 .53436 L
.64191 .53549 L
.63091 .53476 L
.61991 .53216 L
.60891 .52769 L
.59791 .52136 L
.58691 .51316 L
.5759 .50309 L
s
.70148 .50404 m
.69048 .51202 L
.67947 .51813 L
.66847 .52238 L
.65747 .52476 L
.64647 .52527 L
.63547 .52391 L
.62447 .52069 L
.61347 .5156 L
.60246 .50865 L
.59146 .49982 L
s
.71704 .48739 m
.70603 .49662 L
.69503 .50398 L
.68403 .50947 L
.67303 .51309 L
.66203 .51485 L
.65103 .51474 L
.64003 .51276 L
.62902 .50891 L
.61802 .5032 L
.60702 .49562 L
s
.73259 .46981 m
.72159 .48028 L
.71059 .48888 L
.69959 .49562 L
.68859 .50049 L
.67759 .50349 L
.66659 .50462 L
.65558 .50389 L
.64458 .50129 L
.63358 .49682 L
.62258 .49049 L
s
[ .01 .01 ] 0 setdash
.26584 .26195 m
.73259 .26195 L
s
.58723 .34996 m
.3892 .15194 L
s
.15583 .15194 m
.62258 .15194 L
.82061 .34996 L
s
.49922 .26195 m
.49922 .63551 L
s
.73259 .26195 m
.73259 .46981 L
s
.3892 .15194 m
.3892 .46948 L
s
.62258 .15194 m
.62258 .49049 L
s
0 0 m
1 0 L
1 .83664 L
0 .83664 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 240.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000l2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`001P3oool0
0`000000oooo0?ooo`3o0?oooaP0oooo00070?ooo`030000003oool0oooo0?l0oooo5`3oool000L0
oooo0`00003o0?oooaL0oooo00080?ooo`<00000o`3ooolF0?ooo`002@3oool300000?l0oooo5@3o
ool000/0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`00303oool00`000000oooo0?ooo`3o0?oo
oa80oooo000=0?ooo`030000003oool0oooo0?l0oooo4@3oool000h0oooo00<000000?ooo`3oool0
o`3oool@0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000@0?ooo`030000003oool0
oooo0?l0oooo3P3oool00140oooo00<000000?ooo`3oool0o`3oool=0?ooo`004P3oool00`000000
oooo0?ooo`3o0?ooo``0oooo000C0?ooo`030000003oool0oooo0?l0oooo2`3oool001@0oooo00<0
00000?ooo`3oool0o`3oool:0?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000F0?oo
o`030000003oool0oooo0?l0oooo203oool001L0oooo00<000000?ooo`3oool0o`3oool70?ooo`00
603oool00`000000oooo0?ooo`3o0?ooo`H0oooo000I0?ooo`030000003oool0oooo0?l0oooo1@3o
ool001X0oooo00<000000?ooo`3oool0o`3oool40?ooo`006`3oool00`000000oooo0?ooo`3o0?oo
o`<0oooo000L0?ooo`030000003oool0oooo0?l0oooo0P3oool001d0oooo00<000000?ooo`3oool0
o`3oool10?ooo`007P3oool00`000000oooo0?ooo`3o0?ooo`007`3oool00`000000oooo0?ooo`3n
0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`008@3oool00`000000oooo0?ooo`3l0?ooo`00
8P3oool00`000000oooo0?ooo`3k0?ooo`008`3oool00`000000oooo0?ooo`3j0?ooo`00903oool0
0`000000oooo0?ooo`3i0?ooo`009@3oool00`000000oooo0?ooo`3h0?ooo`009P3oool00`000000
oooo0?ooo`3g0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`00:03oool00`000000oooo0?oo
o`3e0?ooo`00:@3oool00`000000oooo0?ooo`3d0?ooo`00:P3oool00`000000oooo0?ooo`3c0?oo
o`00:`3oool00`000000oooo0?ooo`3b0?ooo`00;03oool400000080oooo100000020?ooo`@00000
00<0oooo0000000000000P0000020?ooo`@000000P3oool400000080oooo100000000`3oool00000
0000000200000080oooo100000020?ooo`@000000P3oool300000080oooo1@0000000`3oool00000
0000000200000080oooo100000020?ooo`<000000P3oool400000080oooo100000020?ooo`@00000
00<0oooo0000000000000P0000020?ooo`@000000P3oool400000080oooo100000000`3oool00000
0000000200000080oooo0`00001]0?ooo`00;@3oool00`000000oooo0?ooo`0o0?ooo`030000003o
ool0oooo0400oooo0P00001/0?ooo`00;P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0
00000400oooo00<000000?ooo`3oool0J`3oool002l0oooo00<000000?ooo`3oool0?@3oool01000
0000oooo0?ooo`00000o0?ooo`040000003oool0oooo000006X0oooo000`0?ooo`030000003oool0
oooo0400oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`1W0?ooo`00<@3oool00`00
0000oooo0?ooo`230?ooo`030000003oool0oooo06H0oooo000b0?ooo`030000003oool0oooo03X0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo06/0
oooo000c0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`0i0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0I03oool003@0oooo00<0
00000?ooo`3oool0>03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03P0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`1S0?ooo`00=@3oool00`000000oooo0?ooo`0g
0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1R
0?ooo`00=P3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0:@0oooo000g0?ooo`03
0000003oool0oooo0400oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`1P0?ooo`00
>03oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
=03oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo05l0oooo000i0?ooo`030000003o
ool0oooo03<0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo05h0oooo000j0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0b0?ooo`030000003oool0oooo06/0oooo000k0?ooo`030000003oool0oooo
0340oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0G03oool003`0oooo00<000000?ooo`3oool0@03oool00`000000
oooo0?ooo`100?ooo`030000003oool0oooo05/0oooo000m0?ooo`030000003oool0oooo02l0oooo
00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo05X0oooo
000n0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`0^0?ooo`030000003oool0oooo06/0oooo000o0?ooo`030000003oool0oooo02d0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0F03oool00400oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo02`0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`1G0?oo
o`00@@3oool00`000000oooo0?ooo`230?ooo`030000003oool0oooo05H0oooo00120?ooo`030000
003oool0oooo0440oooo00<000000?ooo`3oool0U`3oool004<0oooo00<000000?ooo`3oool0:@3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`1D0?ooo`00A03oool00`000000oooo0?ooo`0X0?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo05<0oooo00150?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`0W0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0DP3oool004H0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo06/0
oooo00170?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0@03oool00`000000oooo
0?ooo`1@0?ooo`00B03oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0400oooo00<0
00000?ooo`3oool0C`3oool004T0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0J
0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`1>
0?ooo`00BP3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0400oooo00<000000?oo
o`3oool0J`3oool004/0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0L0?ooo`03
0000003oool0oooo0240oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`1<0?ooo`00
C03oool400000080oooo0`0000020?ooo`@000000P3oool400000080oooo100000000`3oool00000
0000000200000080oooo100000020?ooo`@000000P3oool4000000030?ooo`000000000000800000
0P3oool400000080oooo1@0000000`3oool0000000000002000000030?ooo`000000000000800000
0P3oool400000080oooo100000020?ooo`<000000P3oool4000000030?ooo`000000000000<00000
0P3oool400000080oooo0`0000020?ooo`@000000P3oool400000080oooo0`00001=0?ooo`00C@3o
ool00`000000oooo0?ooo`0o0?ooo`800000@@3oool2000004`0oooo001>0?ooo`030000003oool0
oooo03h0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`1;0?ooo`00C`3oool00`00
0000oooo0?ooo`0M0?ooo`030000003oool0oooo01d0oooo00@000000?ooo`3oool000007`3oool0
0`000000oooo0?ooo`0M0?ooo`040000003oool0oooo000004X0oooo001@0?ooo`030000003oool0
oooo01`0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0
oooo0240oooo00<000000?ooo`3oool0A`3oool00540oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0M0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0M0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0AP3oool00580
oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo04/0
oooo001C0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`0i0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0A03oool005@0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0@`3oool005D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`12
0?ooo`00EP3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0400oooo00<000000?oo
o`3oool0J`3oool005L0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0M0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0M0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0@03oool005P0oooo00<000000?ooo`3oool0
=03oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0o0?ooo`00F@3oool00`000000oooo0?ooo`0c0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo03h0oooo001J0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool07@3oool0
0`000000oooo0?ooo`0P0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0B`3oool0
05/0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0l0?ooo`00G03oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0]0?ooo`030000003oool0oooo03/0oooo001M0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03X0oooo
001N0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?oo
o`1;0?ooo`00G`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0;@3oool00`000000oooo0?ooo`1;0?ooo`00H03oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0h0?oo
o`00H@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0a0?ooo`800000>03oool00680oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0
=@3oool006<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0M0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0M0?ooo`030000003o
ool0oooo04/0oooo001T0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool05@3oool0
0`000000oooo0?ooo`0X0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool09@3oool3
000000/0oooo001U0?oook@000001`3oool006D0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`100?ooo`030000003oool0oooo05d0oooo1000000:0?ooo`00I@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0J`3oool006D0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`1;0?ooo`00I@3oool00`000000oooo0?ooo`0W
0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0B`3oool006D0oooo00<000000?oo
o`3oool09`3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo04/0oooo001U0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0P0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool0B`3oool006D0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo06/0oooo001U0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`1[0?ooo`00I@3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0803oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo04/0oooo001U0?ooo`030000003oool0oooo
02L0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`1;0?ooo`00I@3oool00`000000
oooo0?ooo`0W0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0B`3oool006D0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0200oooo
00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`1;0?ooo`00I@3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0J`3oool006D0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo06/0oooo001U0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0P0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool0B`3oool006D0oooo00<000000?ooo`3o
ool09`3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo04/0oooo001U0?ooo`030000
003oool0oooo02L0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`1;0?ooo`00I@3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0803o
ool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo04/0oooo001U0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`1[0?ooo`00I@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0J`3oool006D0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`1;0?ooo`00I@3oool00`000000oooo
0?ooo`0W0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0B`3oool006D0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`1;0?ooo`00I@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0J`3oool006D0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo06/0oooo001U0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0P0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool0B`3oool006D0oooo00<000000?ooo`3oool0
9`3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo04/0oooo001U0?ooo`030000003o
ool0oooo02L0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`1;0?ooo`00I@3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0803oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo04/0oooo001U0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`1[0?ooo`00I@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0J`3oool006D0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0200oooo
00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`1;0?ooo`00I@3oool00`000000oooo0?oo
o`0W0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0B`3oool006D0oooo00<00000
0?ooo`3oool01`3oool2000001h0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`1;
0?ooo`00I@3oool00`000000oooo0?ooo`070?ooo`040000003oool00000000001`0oooo00<00000
0?ooo`3oool0803oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo04`0oooo001U0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P00000m0?ooo`030000003oool0oooo
01/0oooo00<000000?ooo`3oool0C@3oool006D0oooo00<000000?ooo`3oool0203oool010000000
oooo0?ooo`3oool3000003/0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`1>0?oo
o`00I@3oool00`000000oooo0?ooo`090?ooo`060000003oool0oooo0?ooo`000000oooo0`00000E
0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`1?
0?ooo`00I@3oool00`000000oooo0?ooo`090?ooo`050000003oool0oooo0?ooo`0000000P3oool0
10000000oooo00000000000C0?ooo`030000003oool0oooo03X0oooo0P00001B0?ooo`00I@3oool0
0`000000oooo0?ooo`0:0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`0200000140oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0F0?ooo`800000D`3o
ool006D0oooo00<000000?ooo`3oool02P3oool200000080oooo00@000000?ooo`3oool000000`3o
ool3000000l0oooo00<000000?ooo`3oool07P3oool2000000030?ooo`000000000001@0oooo0`00
001D0?ooo`00I@3oool00`000000oooo0?ooo`0;0?ooo`<0000000D0oooo0000003oool0oooo0000
00030?ooo`030000003oool0000000<00000:03oool4000000D0oooo0P00000@0?ooo`D00000E03o
ool006D0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0200000080oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0000000<00000803oool4000000<0oooo0P00
00020?ooo`8000000P3oool3000000X0oooo1`00001E0?ooo`00I@3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00<0000000<0oooo0000003oool00P3oool010000000oooo0?ooo`00
00040?ooo`D000000`3oool00`000000oooo0?ooo`0A0?ooo`D000000P3oool2000000<0oooo1000
00040?ooo`030000003oool0oooo00/0000000<0oooo0000000000000P00001F0?ooo`00I@3oool0
0`000000oooo0?ooo`0<0?ooo`060000003oool0oooo0?ooo`000000oooo100000000`3oool00000
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3ooolH000000<0oooo00<000000?ooo`3o
ool00`3oool3000000<0oooo0P0000000`3oool00000000000030?ooo`80000000@0oooo00000000
0000oooo0P0000000`3oool000000?ooo`04000005L0oooo001U0?ooo`030000003oool0oooo00d0
oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`04000000030?ooo`000000oooo
00<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`000000103oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0
0P0000000`3oool00000000000040?ooo`<000000P3oool2000000040?ooo`00000000000?ooo`80
00000P3oool6000005P0oooo001U0?ooo`030000003oool0oooo00d0oooo00D000000?ooo`3oool0
oooo000000020?ooo`060000003oool0oooo0?ooo`000000oooo1@0000000`3oool000000?ooo`02
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`050000003o
ool0oooo0?ooo`000000103oool010000000oooo0?ooo`3oool4000000D0oooo100000030?oooa40
0000F@3oool006D0oooo00<000000?ooo`3oool03P3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool4000000030?ooo`000000oooo
00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`050000003oool0oooo0?ooo`0000000`3o
ool4000000<0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`040000003o
ool0oooo00000080oooo1`00001J0?ooo`00I@3oool00`000000oooo0?ooo`0>0?ooo`<0000000D0
oooo0000003oool0oooo000000030?ooo`050000003oool0oooo0?ooo`000000103ooolH00000080
oooo0P0000040?ooo`<000001@3oool300000080oooo0P000000103oool000000000003oool50000
00030?ooo`000000000005/0oooo001U0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`00
00000P0000000`3oool000000?ooo`030?ooo`040000003oool0oooo000000@0oooo00@000000?oo
o`3oool0oooo0P0000030?ooo`050000003oool0oooo0?ooo`000000103oool01@000000oooo0?oo
o`3oool0000000D0oooo100000020?ooo`8000000P3oool2000000<0oooo2P0000000`3oool00000
0?ooo`02000005`0oooo001U0?ooo`030000003oool0oooo00l0oooo00@000000?ooo`3oool0oooo
1P0000000`3oool000000?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0P0000030?ooo`050000003oool0oooo0?ooo`0000001@3oool01@000000oooo0?ooo`3oool00000
0080oooo0P0000020?ooo`030000003oool0oooo00<0oooo0P0000030?ooo`8000000`3oool01`00
0000oooo0?ooo`000000oooo0000003oool01000001M0?ooo`00I@3oool00`000000oooo0?ooo`0@
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`0000000`0000000`3oool000000?oo
o`030?ooo`050000003oool0oooo0?ooo`000000103oool01@000000oooo0?ooo`3oool0000000<0
oooo200000050?ooo`030000003oool0oooo008000000P3oool3000000<0oooo0P000000103oool0
00000000003oool6000005h0oooo001U0?ooo`030000003oool0oooo0100oooo00D000000?ooo`3o
ool0oooo000000030?ooo`040000003oool0oooo0?oooaP000000`3oool010000000oooo0?ooo`3o
ool2000000<0oooo100000030?ooo`8000000P3oool>000005l0oooo001U0?ooo`030000003oool0
oooo0140oooo0P0000000`3oool000000?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3o
ool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool01@000000oooo
0?ooo`3oool0000000D0oooo00@000000?ooo`3oool0oooo100000040?ooo`<000000`3oool20000
0080oooo0P0000000`3oool000000000000500000600oooo001U0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`000000100000000`3oool000000?ooo`020?ooo`050000003oool0oooo0?oo
o`0000000`3oool01@000000oooo0000003oool0000000@0oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`3oool500000080oooo0P0000020?ooo`8000000`3oool300000080oooo0P00
00000`3oool000000000000600000640oooo001U0?ooo`030000003oool0oooo0180oooo00@00000
0?ooo`3oool000000P3oool4000000030?ooo`000000oooo00<0oooo00@000000?ooo`3oool0oooo
0P0000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0oooo100000030?ooo`03
0000003oool0oooo00<0oooo0P0000050?ooo`030000003oool0oooo00/00000H`3oool006D0oooo
00<000000?ooo`3oool04P3oool01@000000oooo0?ooo`3oool0000000@0oooo600000020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00P0000000`3oool00000000000020?ooo`80
00000P3oool200000080oooo00<000000?ooo`0000001000001T0?ooo`00I@3oool00`000000oooo
0?ooo`0C0?ooo`040000003oool0oooo000000@0oooo00D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0oooo008000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
0080oooo0P0000030?ooo`<00000103oool700000080oooo0P0000000`3oool00000000000030000
06D0oooo001U0?ooo`030000003oool0oooo01<0oooo00D000000?ooo`3oool0oooo000000040?oo
o`040000003oool0oooo000000@0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool0oooo1@0000030?ooo`@000000`3oool200000080oooo
1`0000000`3oool000000?ooo`1U0?ooo`00I@3oool00`000000oooo0?ooo`0D0?ooo`80000000<0
oooo0000003oool00`3oool01@000000oooo0?ooo`3oool0000000@0oooo00D000000?ooo`3oool0
oooo000000040?ooo`040000003oool0oooo0?ooo`@000000`3oool200000080oooo0P000000103o
ool000000000003oool2000000<0oooo0P0000020?ooo`<0000000<0oooo0000003oool0IP3oool0
06D0oooo00<000000?ooo`3oool05@3ooolM00000080oooo00<000000?ooo`3oool00`3oool30000
00D0oooo0P0000020?ooo`8000000P3oool6000006P0oooo001U0?ooo`030000003oool0oooo01D0
oooo00D000000?ooo`3oool0oooo000000040?ooo`050000003oool0oooo0?ooo`000000103oool0
1@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0200000080oooo0P0000020?ooo`8000000P3oool8000000030?ooo`000000000006T0oooo001U
0?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool00000103oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`040000
003oool0oooo0?ooo`<000001@3oool3000000<0oooo0P0000000`3oool000000000000200000003
0?ooo`000000000006/0oooo001U0?ooo`030000003oool0oooo01H0oooo00D000000?ooo`3oool0
oooo000000040?ooo`050000003oool0oooo0?ooo`0000000`3oool2000000<0oooo2@0000020?oo
o`8000000P3oool2000000<0oooo2`00001]0?ooo`00I@3oool00`000000oooo0?ooo`0G0?oooaD0
00000P3oool00`000000oooo0?ooo`020?ooo`8000000`3oool3000000@0oooo0P0000020?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool0K03oool006D0oooo00<000000?ooo`3o
ool0603oool01@000000oooo0?ooo`3oool0000000@0oooo00L000000?ooo`3oool0oooo0000003o
ool000000080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`3oool5000000<0oooo
100000020?ooo`80000000@0oooo000000000000oooo0P00001_0?ooo`00I@3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000040?ooo`80
00000`3oool010000000oooo0?ooo`3oool4000000<0oooo0P0000020?ooo`8000000`3oool80000
0740oooo001U0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0?ooo`3oool0000000@0oooo00@000000?ooo`3oool0oooo100000020?ooo`800000103oool3
000000<0oooo0P0000020?ooo`8000000P3oool00`000000oooo0?ooo`1`0?ooo`00I@3oool00`00
0000oooo0?ooo`0J0?oooa4000000P3oool00`000000oooo0?ooo`030?ooo`@000000`3oool30000
0080oooo0P0000020?ooo`800000L`3oool006D0oooo00<000000?ooo`3oool06`3oool00`000000
oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo008000000P3oool200000080oooo0P0000020?ooo`H00000M@3oool006D0
oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`3oool3000000D0oooo0`0000030?oo
o`8000000P3oool2000007H0oooo001U0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`3oool900000080oooo0P0000020?ooo`8000000`3oool30000
0080oooo0P00001h0?ooo`00I@3oool00`000000oooo0?ooo`0M0?ooo`P000000P3oool00`000000
oooo0?ooo`020?ooo`8000000`3oool3000000<0oooo0P0000030?ooo`800000NP3oool006D0oooo
00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0?ooo`80
00000`3oool5000000<0oooo0`0000040?ooo`800000N`3oool006D0oooo00<000000?ooo`3oool0
7P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D000000`3oool200000080oooo
0P0000020?ooo`@00000O@3oool006D0oooo00<000000?ooo`3oool07`3oool010000000oooo0?oo
o`3oool500000080oooo0P0000040?ooo`<000000`3oool200000800oooo001U0?ooo`030000003o
ool0oooo0200oooo0`0000030?ooo`030000003oool0oooo00<0oooo100000030?ooo`<00000PP3o
ool006D0oooo00<000000?ooo`3oool08@3oool2000000@0oooo00<000000?ooo`3oool00P000002
0?ooo`8000000P3oool2000008@0oooo001U0?ooo`030000003oool0oooo02<0oooo1`0000050?oo
o`<00000QP3oool006D0oooo00<000000?ooo`3oool09@3oool010000000oooo0000003oool20000
0080oooo0P0000290?ooo`00I@3oool00`000000oooo0?ooo`0V0?ooo`8000000P3oool3000008/0
oooo001U0?ooo`030000003oool0oooo02L0oooo0`00002>0?ooo`00I@3oool00`000000oooo0?oo
o`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?oo
o`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3o
ool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`00
0000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo
0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h
0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00
I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool0
0`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000
oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?oo
o`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?oo
o`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3o
ool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`00
0000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo
0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h
0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00
I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool0
0`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000
oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?oo
o`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?oo
o`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3o
ool00`000000oooo0?ooo`2h0?ooo`00I03oool300000;T0oooo001T0?ooo`<00000^@3oool006@0
oooo0`00002i0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00I@3oool00`000000oooo0?oo
o`2h0?ooo`00I@3oool00`000000oooo0?ooo`2h0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {239.938, 0}} -> {-2.27678, -2.24938, \
0.022412, 0.022412}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
WindowSize->{981, 723},
WindowMargins->{{93, Automatic}, {Automatic, 19}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1456, 27, 262, "Input"],
Cell[3213, 80, 1013, 19, 190, "Input"],

Cell[CellGroupData[{
Cell[4251, 103, 131, 2, 30, "Input"],
Cell[4385, 107, 31728, 776, 249, 6735, 463, "GraphicsData", "PostScript", \
"Graphics"],
Cell[36116, 885, 130, 3, 29, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

