(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21447,        503]*)
(*NotebookOutlinePosition[     22155,        527]*)
(*  CellTagsIndexPosition[     22111,        523]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(x1 = \(-0.5\); x2 = 1.5; y1 = \(-0.5\); y2 = 1.5;\), "\n", 
    \(rx = x2 - x1; ry = y2 - y1;\), "\[IndentingNewLine]", 
    \(\(ar = ry/rx;\)\), "\[IndentingNewLine]", 
    \(wx = rx/36; hx = 0.2*wx;\), "\[IndentingNewLine]", 
    \(wy = ry/36; hy = 0.2*wy;\), "\n", 
    \(LX = {Thickness[0.00402], {Line[{{x1, 0}, {x2, 0}}], 
          Line[{{x2 - wx, \(-hx\)}, {x2, 0}, {x2 - wx, hx}}]}}; 
    LY = {Thickness[0.00402], {Line[{{0, y1}, {0, y2}}], 
          Line[{{\(-hy\), y2 - wy}, {0, y2}, {hy, y2 - wy}}]}};\)}], "Input"],

Cell[BoxData[
    \(\(f[x_] := x^2;\)\)], "Input"],

Cell[BoxData[
    \(fL = {Thickness[0.00405], Line[Table[{x, f[x]}, {x, 0, 1.1, 0.01}]]}; 
    DL1 = {Dashing[{0.01, 0.01}], 
        Line[Table[{x, f[x]}, {x, \(-0.45\), 0, 0.01}]]};\)], "Input"],

Cell[BoxData[{
    \(\(DL2 = {Dashing[{0.01, 0.01}], 
          Line[{{0, 1}, {1, 1}}]};\)\), "\[IndentingNewLine]", 
    \(\(SL = Line[{{1, 0}, {1, 1}}];\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[{LX, LY, fL, SL, DL1, DL2}], 
      AspectRatio \[Rule] Automatic, PlotRange \[Rule] All]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.47619 0.261905 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.00402 w
[ ] 0 setdash
.02381 .2619 m
.97619 .2619 L
s
.94974 .25661 m
.97619 .2619 L
.94974 .2672 L
s
.2619 .02381 m
.2619 .97619 L
s
.25661 .94974 m
.2619 .97619 L
.2672 .94974 L
s
.00405 w
.2619 .2619 m
.26667 .26195 L
.27143 .2621 L
.27619 .26233 L
.28095 .26267 L
.28571 .2631 L
.29048 .26362 L
.29524 .26424 L
.3 .26495 L
.30476 .26576 L
.30952 .26667 L
.31429 .26767 L
.31905 .26876 L
.32381 .26995 L
.32857 .27124 L
.33333 .27262 L
.3381 .2741 L
.34286 .27567 L
.34762 .27733 L
.35238 .2791 L
.35714 .28095 L
.3619 .2829 L
.36667 .28495 L
.37143 .2871 L
.37619 .28933 L
.38095 .29167 L
.38571 .2941 L
.39048 .29662 L
.39524 .29924 L
.4 .30195 L
.40476 .30476 L
.40952 .30767 L
.41429 .31067 L
.41905 .31376 L
.42381 .31695 L
.42857 .32024 L
.43333 .32362 L
.4381 .3271 L
.44286 .33067 L
.44762 .33433 L
.45238 .3381 L
.45714 .34195 L
.4619 .3459 L
.46667 .34995 L
.47143 .3541 L
.47619 .35833 L
.48095 .36267 L
.48571 .3671 L
.49048 .37162 L
.49524 .37624 L
Mistroke
.5 .38095 L
.50476 .38576 L
.50952 .39067 L
.51429 .39567 L
.51905 .40076 L
.52381 .40595 L
.52857 .41124 L
.53333 .41662 L
.5381 .4221 L
.54286 .42767 L
.54762 .43333 L
.55238 .4391 L
.55714 .44495 L
.5619 .4509 L
.56667 .45695 L
.57143 .4631 L
.57619 .46933 L
.58095 .47567 L
.58571 .4821 L
.59048 .48862 L
.59524 .49524 L
.6 .50195 L
.60476 .50876 L
.60952 .51567 L
.61429 .52267 L
.61905 .52976 L
.62381 .53695 L
.62857 .54424 L
.63333 .55162 L
.6381 .5591 L
.64286 .56667 L
.64762 .57433 L
.65238 .5821 L
.65714 .58995 L
.6619 .5979 L
.66667 .60595 L
.67143 .6141 L
.67619 .62233 L
.68095 .63067 L
.68571 .6391 L
.69048 .64762 L
.69524 .65624 L
.7 .66495 L
.70476 .67376 L
.70952 .68267 L
.71429 .69167 L
.71905 .70076 L
.72381 .70995 L
.72857 .71924 L
.73333 .72862 L
Mistroke
.7381 .7381 L
.74286 .74767 L
.74762 .75733 L
.75238 .7671 L
.75714 .77695 L
.7619 .7869 L
.76667 .79695 L
.77143 .8071 L
.77619 .81733 L
.78095 .82767 L
.78571 .8381 L
Mfstroke
.5 Mabswid
.7381 .2619 m
.7381 .7381 L
s
[ .01 .01 ] 0 setdash
.04762 .35833 m
.05238 .3541 L
.05714 .34995 L
.0619 .3459 L
.06667 .34195 L
.07143 .3381 L
.07619 .33433 L
.08095 .33067 L
.08571 .3271 L
.09048 .32362 L
.09524 .32024 L
.1 .31695 L
.10476 .31376 L
.10952 .31067 L
.11429 .30767 L
.11905 .30476 L
.12381 .30195 L
.12857 .29924 L
.13333 .29662 L
.1381 .2941 L
.14286 .29167 L
.14762 .28933 L
.15238 .2871 L
.15714 .28495 L
.1619 .2829 L
.16667 .28095 L
.17143 .2791 L
.17619 .27733 L
.18095 .27567 L
.18571 .2741 L
.19048 .27262 L
.19524 .27124 L
.2 .26995 L
.20476 .26876 L
.20952 .26767 L
.21429 .26667 L
.21905 .26576 L
.22381 .26495 L
.22857 .26424 L
.23333 .26362 L
.2381 .2631 L
.24286 .26267 L
.24762 .26233 L
.25238 .2621 L
.25714 .26195 L
.2619 .2619 L
s
.2619 .7381 m
.7381 .7381 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{227.125, 227.125},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003S0000hb000`400?l00000o`00003oh`3oool0
0><0oooo003S0?ooo`00h`3oool00><0oooo003S0?ooo`00>`3oool00`000000oooo0?ooo`2U0?oo
o`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3o
ool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`00
0000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo
0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U
0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00
>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool0
0`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000
oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?oo
o`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?oo
o`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3o
ool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`00
0000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo
0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U
0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00
>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool0
0`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000
oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?oo
o`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?oo
o`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3o
ool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`00
0000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo
0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U
0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00
>`3oool00`000000oooo0?ooo`2H0?ooo`8000002`3oool003/0oooo00<000000?ooo`3oool0VP3o
ool3000000P0oooo00050?ooomP000001P3oool002d0oooo0`00000;0?ooo`030000003oool0oooo
00L0oooo1@00001L0?ooo`030000003oool0oooo02d0oooo100000090?ooo`00:@3oool3000000l0
oooo00<000000?ooo`3oool0303oool3000005T0oooo00<000000?ooo`3oool0>P3oool002H0oooo
0P0000000`3oool000000?ooo`0@0?ooo`030000003oool0oooo00l0oooo0`00001F0?ooo`030000
003oool0oooo03X0oooo000U0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04P3o
ool2000005@0oooo00<000000?ooo`3oool0>P3oool00280oooo0P00000G0?ooo`030000003oool0
oooo01@0oooo0P00001B0?ooo`030000003oool0oooo03X0oooo000P0?ooo`8000006@3oool00`00
0000oooo0?ooo`0F0?ooo`<00000C`3oool00`000000oooo0?ooo`0j0?ooo`007P3oool00`000000
oooo0?ooo`0J0?ooo`030000003oool0oooo01T0oooo0P00001=0?ooo`030000003oool0oooo03X0
oooo000L0?ooo`8000007@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo04X0oooo
00<000000?ooo`3oool0>P3oool001X0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?oo
o`0L0?ooo`800000BP3oool00`000000oooo0?ooo`0j0?ooo`006@3oool00`000000oooo0?ooo`0O
0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`0j
0?ooo`00>`3oool00`000000oooo0?ooo`0O0?ooo`800000A`3oool00`000000oooo0?ooo`0j0?oo
o`005P3oool2000002<0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`140?ooo`03
0000003oool0oooo03X0oooo000E0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0
8P3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo03X0oooo000C0?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool08`3oool300000480oooo00<000000?ooo`3oool0>P3o
ool00180oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo03l0oooo00<000000?ooo`3oool0>P3oool00140oooo00<000000?ooo`3oool09`3oool00`00
0000oooo0?ooo`0W0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool0>P3oool000l0
oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo03d0
oooo00<000000?ooo`3oool0>P3oool000h0oooo0P00000[0?ooo`030000003oool0oooo02T0oooo
00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo0?oo
o`0Z0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0>P3oool000/0oooo0P00000^
0?ooo`030000003oool0oooo02/0oooo0P00000k0?ooo`030000003oool0oooo03X0oooo000:0?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0h0?oo
o`030000003oool0oooo03X0oooo000k0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3o
ool0=`3oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo0?ooo`0_0?ooo`030000
003oool0oooo03H0oooo00<000000?ooo`3oool0>P3oool003/0oooo00<000000?ooo`3oool0<03o
ool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo03X0oooo000k0?ooo`030000003oool0
oooo0340oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`00
0000oooo0?ooo`0b0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0>P3oool003/0
oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo03X0
oooo000k0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0<@3oool00`000000oooo
0?ooo`0j0?ooo`00>`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo0300oooo00<0
00000?ooo`3oool0>P3oool003/0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0_
0?ooo`030000003oool0oooo03X0oooo000k0?ooo`030000003oool0oooo03L0oooo00<000000?oo
o`3oool0;P3oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo0?ooo`0h0?ooo`03
0000003oool0oooo02d0oooo00<000000?ooo`3oool0>P3oool003/0oooo00<000000?ooo`3oool0
>@3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo03X0oooo000k0?ooo`030000003o
ool0oooo03T0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0j0?ooo`00>`3oool0
0`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0>P3oool0
03/0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo
03X0oooo000k0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0:@3oool00`000000
oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo02P0oooo
00<000000?ooo`3oool0>P3oool003/0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?oo
o`0X0?ooo`030000003oool0oooo03X0oooo000k0?ooo`030000003oool0oooo03h0oooo00<00000
0?ooo`3oool09`3oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo0?ooo`0o0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool0>P3oool003/0oooo00<000000?ooo`3o
ool0@03oool2000002H0oooo00<000000?ooo`3oool0>P3oool003/0oooo00<000000?ooo`3oool0
@@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo03X0oooo000k0?ooo`030000003o
ool0oooo0480oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0j0?ooo`00>`3oool0
0`000000oooo0?ooo`130?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0>P3oool0
03/0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo
03X0oooo000k0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool08@3oool00`000000
oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo0200oooo
00<000000?ooo`3oool0>P3oool003/0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?oo
o`0O0?ooo`030000003oool0oooo03X0oooo000k0?ooo`030000003oool0oooo04H0oooo00<00000
0?ooo`3oool07`3oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo0?ooo`170?oo
o`030000003oool0oooo01h0oooo00<000000?ooo`3oool0>P3oool003/0oooo00<000000?ooo`3o
ool0B03oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo03X0oooo000k0?ooo`030000
003oool0oooo04P0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0j0?ooo`00>`3o
ool00`000000oooo0?ooo`190?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0>P3o
ool003/0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo03X0oooo000k0?ooo`030000003oool0oooo04X0oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool0>P3oool003/0oooo00<000000?ooo`3oool0B`3oool00`000000oooo
0?ooo`0J0?ooo`030000003oool0oooo03X0oooo000k0?ooo`030000003oool0oooo04`0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo0?ooo`1=
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0>P3oool003/0oooo00<000000?oo
o`3oool0CP3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03X0oooo000k0?ooo`03
0000003oool0oooo04l0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0j0?ooo`00
>`3oool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0
>P3oool003/0oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo03X0oooo000k0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool0>P3oool003/0oooo00<000000?ooo`3oool0DP3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo03X0oooo000k0?ooo`030000003oool0oooo0580oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo0?oo
o`1C0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0>P3oool003/0oooo00<00000
0?ooo`3oool0E03oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03X0oooo000k0?oo
o`030000003oool0oooo05@0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?oo
o`00>`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0>P3oool003/0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo03X0oooo000k0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0>P3oool003/0oooo00<000000?ooo`3oool0E`3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo03X0oooo000k0?ooo`030000003oool0oooo05P0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo
0?ooo`1H0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0>P3oool003/0oooo00<0
00000?ooo`3oool0F@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo03X0oooo000k
0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0j
0?ooo`00>`3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0>P3oool003/0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo03X0oooo000k0?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo0?ooo`1L0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0>P3oool003/0oooo00<000000?ooo`3oool0G@3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo03X0oooo000k0?ooo`030000003oool0oooo
05d0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000
oooo0?ooo`1N0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0>P3oool003/0oooo
00<000000?ooo`3oool0GP3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo03X0oooo
000k0?ooo`030000003oool0oooo05l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0j0?ooo`00>`3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0>P3oool003/0oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo03X0oooo000k0?ooo`030000003oool0oooo0600oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo0?ooo`1Q0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0>P3oool003/0oooo00<000000?ooo`3oool0H@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo03X0oooo000k0?ooo`030000003oool0
oooo0680oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`00
0000oooo0?ooo`1R0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0>P3oool003/0
oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo03X0
oooo000k0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0j0?ooo`00>`3oool00`000000oooo0?ooo`1T0?ooo`050000003oool0oooo0?ooo`000000
?03oool003/0oooo00<000000?ooo`3oool0I03oool01@000000oooo0?ooo`3oool0000003`0oooo
000k0?ooo`030000003oool0oooo06D0oooo00@000000?ooo`3oool00000?03oool003/0oooo00<0
00000?ooo`3oool0I@3oool010000000oooo0?ooo`00000l0?ooo`00>`3oool00`000000oooo0?oo
o`1V0?ooo`030000003oool0000003`0oooo000k0?ooo`030000003oool0oooo06H0oooo00<00000
0?ooo`000000?03oool003/0oooo00<000000?ooo`3oool0I`3oool2000003`0oooo000k0?ooo`03
0000003oool0oooo06L0oooo0P00000l0?ooo`00>`3oool3000000040?ooo`000000000000000080
oooo0`0000000`3oool0000000000002000000050?ooo`00000000000000003oool0100000001@3o
ool00000000000000000oooo00@0000000D0oooo00000000000000000?ooo`04000000050?ooo`00
000000000000003oool0100000001@3oool00000000000000000oooo00@0000000@0oooo00000000
000000000P3oool3000000040?ooo`000000000000000080oooo0`000000103oool0000000000000
00020?ooo`<0000000@0oooo00000000000000000P3oool3000000040?ooo`000000000000000080
oooo1000000l0?ooo`00>`3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo03X0oooo
000k0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool0>@3oool003/0oooo00<00000
0?ooo`3oool0JP3oool00`000000oooo0?ooo`0h0?ooo`00>`3oool00`000000oooo0?ooo`1Z0?oo
o`030000003oool0oooo03P0oooo000k0?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3o
ool0=`3oool003/0oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`0g0?ooo`00>`3o
ool00`000000oooo0?ooo`1/0?ooo`030000003oool0oooo03H0oooo000k0?ooo`030000003oool0
oooo06`0oooo00<000000?ooo`3oool0=P3oool003/0oooo00<000000?ooo`3oool0K@3oool00`00
0000oooo0?ooo`0e0?ooo`00>`3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo03D0
oooo000k0?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3oool0=03oool003/0oooo00<0
00000?ooo`3oool0KP3oool00`000000oooo0?ooo`0d0?ooo`00>`3oool00`000000oooo0?ooo`1_
0?ooo`030000003oool0oooo03<0oooo000k0?ooo`030000003oool0oooo06l0oooo00<000000?oo
o`3oool0<`3oool003/0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`0c0?ooo`00
>`3oool00`000000oooo0?ooo`1`0?ooo`030000003oool0oooo0380oooo000k0?ooo`030000003o
ool0oooo0700oooo00<000000?ooo`3oool0<P3oool003/0oooo00<000000?ooo`3oool0L@3oool0
0`000000oooo0?ooo`0a0?ooo`00>`3oool00`000000oooo0?ooo`1a0?ooo`030000003oool0oooo
0340oooo000k0?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool0<03oool003/0oooo
00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`0`0?ooo`00>`3oool00`000000oooo0?oo
o`1b0?ooo`030000003oool0oooo0300oooo000k0?ooo`030000003oool0oooo07<0oooo00<00000
0?ooo`3oool0;`3oool003/0oooo00<000000?ooo`3oool0Y@3oool003/0oooo00<000000?ooo`3o
ool0Y@3oool003/0oooo00<000000?ooo`3oool0Y@3oool003/0oooo00<000000?ooo`3oool0Y@3o
ool003/0oooo00<000000?ooo`3oool0Y@3oool003/0oooo00<000000?ooo`3oool0Y@3oool003/0
oooo00<000000?ooo`3oool0Y@3oool003/0oooo00<000000?ooo`3oool0Y@3oool003/0oooo00<0
00000?ooo`3oool0Y@3oool003/0oooo00<000000?ooo`3oool0Y@3oool003/0oooo00<000000?oo
o`3oool0Y@3oool003/0oooo00<000000?ooo`3oool0Y@3oool003/0oooo00<000000?ooo`3oool0
Y@3oool003/0oooo00<000000?ooo`3oool0Y@3oool003/0oooo00<000000?ooo`3oool0Y@3oool0
03/0oooo00<000000?ooo`3oool0Y@3oool003/0oooo00<000000?ooo`3oool0Y@3oool003/0oooo
00<000000?ooo`3oool0Y@3oool003/0oooo00<000000?ooo`3oool0Y@3oool003/0oooo00<00000
0?ooo`3oool0Y@3oool003/0oooo00<000000?ooo`3oool0Y@3oool003/0oooo00<000000?ooo`3o
ool0Y@3oool003/0oooo00<000000?ooo`3oool0Y@3oool003/0oooo00<000000?ooo`3oool0Y@3o
ool003X0oooo0`00002V0?ooo`00>P3oool300000:H0oooo000j0?ooo`<00000YP3oool003X0oooo
0P00002W0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00>`3oool00`000000oooo0?ooo`2U
0?ooo`00>`3oool00`000000oooo0?ooo`2U0?ooo`00h`3oool00><0oooo003S0?ooo`00h`3oool0
0><0oooo0000\
\>"],
  ImageRangeCache->{{{0, 226.125}, {226.125, 0}} -> {-0.550012, -0.550012, \
0.009287, 0.009287}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
WindowSize->{850, 791},
WindowMargins->{{Automatic, 121}, {Automatic, 45}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 550, 9, 150, "Input"],
Cell[2307, 62, 50, 1, 30, "Input"],
Cell[2360, 65, 196, 3, 50, "Input"],
Cell[2559, 70, 170, 3, 50, "Input"],

Cell[CellGroupData[{
Cell[2754, 77, 136, 2, 30, "Input"],
Cell[2893, 81, 18405, 414, 236, 3320, 223, "GraphicsData", "PostScript", \
"Graphics"],
Cell[21301, 497, 130, 3, 29, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

